/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output for ImportVolume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ImportVolumeResponse extends EC2Response implements
        ToCopyableBuilder<ImportVolumeResponse.Builder, ImportVolumeResponse> {
    private final ConversionTask conversionTask;

    private ImportVolumeResponse(BuilderImpl builder) {
        super(builder);
        this.conversionTask = builder.conversionTask;
    }

    /**
     * <p>
     * Information about the conversion task.
     * </p>
     * 
     * @return Information about the conversion task.
     */
    public ConversionTask conversionTask() {
        return conversionTask;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(conversionTask());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportVolumeResponse)) {
            return false;
        }
        ImportVolumeResponse other = (ImportVolumeResponse) obj;
        return Objects.equals(conversionTask(), other.conversionTask());
    }

    @Override
    public String toString() {
        return ToString.builder("ImportVolumeResponse").add("ConversionTask", conversionTask()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConversionTask":
            return Optional.of(clazz.cast(conversionTask()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, ImportVolumeResponse> {
        /**
         * <p>
         * Information about the conversion task.
         * </p>
         * 
         * @param conversionTask
         *        Information about the conversion task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversionTask(ConversionTask conversionTask);

        /**
         * <p>
         * Information about the conversion task.
         * </p>
         * This is a convenience that creates an instance of the {@link ConversionTask.Builder} avoiding the need to
         * create one manually via {@link ConversionTask#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConversionTask.Builder#build()} is called immediately and its
         * result is passed to {@link #conversionTask(ConversionTask)}.
         * 
         * @param conversionTask
         *        a consumer that will call methods on {@link ConversionTask.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conversionTask(ConversionTask)
         */
        default Builder conversionTask(Consumer<ConversionTask.Builder> conversionTask) {
            return conversionTask(ConversionTask.builder().apply(conversionTask).build());
        }
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private ConversionTask conversionTask;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportVolumeResponse model) {
            super(model);
            conversionTask(model.conversionTask);
        }

        public final ConversionTask.Builder getConversionTask() {
            return conversionTask != null ? conversionTask.toBuilder() : null;
        }

        @Override
        public final Builder conversionTask(ConversionTask conversionTask) {
            this.conversionTask = conversionTask;
            return this;
        }

        public final void setConversionTask(ConversionTask.BuilderImpl conversionTask) {
            this.conversionTask = conversionTask != null ? conversionTask.build() : null;
        }

        @Override
        public ImportVolumeResponse build() {
            return new ImportVolumeResponse(this);
        }
    }
}
