/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of ImportKeyPair.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ImportKeyPairResponse extends EC2Response implements
        ToCopyableBuilder<ImportKeyPairResponse.Builder, ImportKeyPairResponse> {
    private final String keyFingerprint;

    private final String keyName;

    private ImportKeyPairResponse(BuilderImpl builder) {
        super(builder);
        this.keyFingerprint = builder.keyFingerprint;
        this.keyName = builder.keyName;
    }

    /**
     * <p>
     * The MD5 public key fingerprint as specified in section 4 of RFC 4716.
     * </p>
     * 
     * @return The MD5 public key fingerprint as specified in section 4 of RFC 4716.
     */
    public String keyFingerprint() {
        return keyFingerprint;
    }

    /**
     * <p>
     * The key pair name you provided.
     * </p>
     * 
     * @return The key pair name you provided.
     */
    public String keyName() {
        return keyName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyFingerprint());
        hashCode = 31 * hashCode + Objects.hashCode(keyName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportKeyPairResponse)) {
            return false;
        }
        ImportKeyPairResponse other = (ImportKeyPairResponse) obj;
        return Objects.equals(keyFingerprint(), other.keyFingerprint()) && Objects.equals(keyName(), other.keyName());
    }

    @Override
    public String toString() {
        return ToString.builder("ImportKeyPairResponse").add("KeyFingerprint", keyFingerprint()).add("KeyName", keyName())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyFingerprint":
            return Optional.of(clazz.cast(keyFingerprint()));
        case "KeyName":
            return Optional.of(clazz.cast(keyName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, ImportKeyPairResponse> {
        /**
         * <p>
         * The MD5 public key fingerprint as specified in section 4 of RFC 4716.
         * </p>
         * 
         * @param keyFingerprint
         *        The MD5 public key fingerprint as specified in section 4 of RFC 4716.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyFingerprint(String keyFingerprint);

        /**
         * <p>
         * The key pair name you provided.
         * </p>
         * 
         * @param keyName
         *        The key pair name you provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyName(String keyName);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private String keyFingerprint;

        private String keyName;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportKeyPairResponse model) {
            super(model);
            keyFingerprint(model.keyFingerprint);
            keyName(model.keyName);
        }

        public final String getKeyFingerprint() {
            return keyFingerprint;
        }

        @Override
        public final Builder keyFingerprint(String keyFingerprint) {
            this.keyFingerprint = keyFingerprint;
            return this;
        }

        public final void setKeyFingerprint(String keyFingerprint) {
            this.keyFingerprint = keyFingerprint;
        }

        public final String getKeyName() {
            return keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public ImportKeyPairResponse build() {
            return new ImportKeyPairResponse(this);
        }
    }
}
