/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an import instance task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ImportInstanceTaskDetails implements ToCopyableBuilder<ImportInstanceTaskDetails.Builder, ImportInstanceTaskDetails> {
    private final String description;

    private final String instanceId;

    private final String platform;

    private final List<ImportInstanceVolumeDetailItem> volumes;

    private ImportInstanceTaskDetails(BuilderImpl builder) {
        this.description = builder.description;
        this.instanceId = builder.instanceId;
        this.platform = builder.platform;
        this.volumes = builder.volumes;
    }

    /**
     * <p>
     * A description of the task.
     * </p>
     * 
     * @return A description of the task.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The instance operating system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link PlatformValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The instance operating system.
     * @see PlatformValues
     */
    public PlatformValues platform() {
        return PlatformValues.fromValue(platform);
    }

    /**
     * <p>
     * The instance operating system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link PlatformValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The instance operating system.
     * @see PlatformValues
     */
    public String platformAsString() {
        return platform;
    }

    /**
     * <p>
     * One or more volumes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more volumes.
     */
    public List<ImportInstanceVolumeDetailItem> volumes() {
        return volumes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(volumes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportInstanceTaskDetails)) {
            return false;
        }
        ImportInstanceTaskDetails other = (ImportInstanceTaskDetails) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(platformAsString(), other.platformAsString()) && Objects.equals(volumes(), other.volumes());
    }

    @Override
    public String toString() {
        return ToString.builder("ImportInstanceTaskDetails").add("Description", description()).add("InstanceId", instanceId())
                .add("Platform", platformAsString()).add("Volumes", volumes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "Platform":
            return Optional.of(clazz.cast(platformAsString()));
        case "Volumes":
            return Optional.of(clazz.cast(volumes()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ImportInstanceTaskDetails> {
        /**
         * <p>
         * A description of the task.
         * </p>
         * 
         * @param description
         *        A description of the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The instance operating system.
         * </p>
         * 
         * @param platform
         *        The instance operating system.
         * @see PlatformValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformValues
         */
        Builder platform(String platform);

        /**
         * <p>
         * The instance operating system.
         * </p>
         * 
         * @param platform
         *        The instance operating system.
         * @see PlatformValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformValues
         */
        Builder platform(PlatformValues platform);

        /**
         * <p>
         * One or more volumes.
         * </p>
         * 
         * @param volumes
         *        One or more volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumes(Collection<ImportInstanceVolumeDetailItem> volumes);

        /**
         * <p>
         * One or more volumes.
         * </p>
         * 
         * @param volumes
         *        One or more volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumes(ImportInstanceVolumeDetailItem... volumes);

        /**
         * <p>
         * One or more volumes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ImportInstanceVolumeDetailItem>.Builder}
         * avoiding the need to create one manually via {@link List<ImportInstanceVolumeDetailItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ImportInstanceVolumeDetailItem>.Builder#build()} is called
         * immediately and its result is passed to {@link #volumes(List<ImportInstanceVolumeDetailItem>)}.
         * 
         * @param volumes
         *        a consumer that will call methods on {@link List<ImportInstanceVolumeDetailItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumes(List<ImportInstanceVolumeDetailItem>)
         */
        Builder volumes(Consumer<ImportInstanceVolumeDetailItem.Builder>... volumes);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String instanceId;

        private String platform;

        private List<ImportInstanceVolumeDetailItem> volumes;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportInstanceTaskDetails model) {
            description(model.description);
            instanceId(model.instanceId);
            platform(model.platform);
            volumes(model.volumes);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformValues platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final Collection<ImportInstanceVolumeDetailItem.Builder> getVolumes() {
            return volumes != null ? volumes.stream().map(ImportInstanceVolumeDetailItem::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder volumes(Collection<ImportInstanceVolumeDetailItem> volumes) {
            this.volumes = ImportInstanceVolumeDetailSetCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(ImportInstanceVolumeDetailItem... volumes) {
            volumes(Arrays.asList(volumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Consumer<ImportInstanceVolumeDetailItem.Builder>... volumes) {
            volumes(Stream.of(volumes).map(c -> ImportInstanceVolumeDetailItem.builder().apply(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setVolumes(Collection<ImportInstanceVolumeDetailItem.BuilderImpl> volumes) {
            this.volumes = ImportInstanceVolumeDetailSetCopier.copyFromBuilder(volumes);
        }

        @Override
        public ImportInstanceTaskDetails build() {
            return new ImportInstanceTaskDetails(this);
        }
    }
}
