/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an event in the history of the Spot fleet request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class HistoryRecord implements ToCopyableBuilder<HistoryRecord.Builder, HistoryRecord> {
    private final EventInformation eventInformation;

    private final String eventType;

    private final Instant timestamp;

    private HistoryRecord(BuilderImpl builder) {
        this.eventInformation = builder.eventInformation;
        this.eventType = builder.eventType;
        this.timestamp = builder.timestamp;
    }

    /**
     * <p>
     * Information about the event.
     * </p>
     * 
     * @return Information about the event.
     */
    public EventInformation eventInformation() {
        return eventInformation;
    }

    /**
     * <p>
     * The event type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>error</code> - An error with the Spot fleet request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fleetRequestChange</code> - A change in the status or configuration of the Spot fleet request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instanceChange</code> - An instance was launched or terminated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Information</code> - An informational event.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link EventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The event type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>error</code> - An error with the Spot fleet request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fleetRequestChange</code> - A change in the status or configuration of the Spot fleet request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instanceChange</code> - An instance was launched or terminated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Information</code> - An informational event.
     *         </p>
     *         </li>
     * @see EventType
     */
    public EventType eventType() {
        return EventType.fromValue(eventType);
    }

    /**
     * <p>
     * The event type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>error</code> - An error with the Spot fleet request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fleetRequestChange</code> - A change in the status or configuration of the Spot fleet request.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instanceChange</code> - An instance was launched or terminated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Information</code> - An informational event.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link EventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The event type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>error</code> - An error with the Spot fleet request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fleetRequestChange</code> - A change in the status or configuration of the Spot fleet request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instanceChange</code> - An instance was launched or terminated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Information</code> - An informational event.
     *         </p>
     *         </li>
     * @see EventType
     */
    public String eventTypeAsString() {
        return eventType;
    }

    /**
     * <p>
     * The date and time of the event, in UTC format (for example,
     * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
     * </p>
     * 
     * @return The date and time of the event, in UTC format (for example,
     *         <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
     */
    public Instant timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventInformation());
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HistoryRecord)) {
            return false;
        }
        HistoryRecord other = (HistoryRecord) obj;
        return Objects.equals(eventInformation(), other.eventInformation())
                && Objects.equals(eventTypeAsString(), other.eventTypeAsString())
                && Objects.equals(timestamp(), other.timestamp());
    }

    @Override
    public String toString() {
        return ToString.builder("HistoryRecord").add("EventInformation", eventInformation())
                .add("EventType", eventTypeAsString()).add("Timestamp", timestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EventInformation":
            return Optional.of(clazz.cast(eventInformation()));
        case "EventType":
            return Optional.of(clazz.cast(eventTypeAsString()));
        case "Timestamp":
            return Optional.of(clazz.cast(timestamp()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, HistoryRecord> {
        /**
         * <p>
         * Information about the event.
         * </p>
         * 
         * @param eventInformation
         *        Information about the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventInformation(EventInformation eventInformation);

        /**
         * <p>
         * Information about the event.
         * </p>
         * This is a convenience that creates an instance of the {@link EventInformation.Builder} avoiding the need to
         * create one manually via {@link EventInformation#builder()}.
         *
         * When the {@link Consumer} completes, {@link EventInformation.Builder#build()} is called immediately and its
         * result is passed to {@link #eventInformation(EventInformation)}.
         * 
         * @param eventInformation
         *        a consumer that will call methods on {@link EventInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventInformation(EventInformation)
         */
        default Builder eventInformation(Consumer<EventInformation.Builder> eventInformation) {
            return eventInformation(EventInformation.builder().apply(eventInformation).build());
        }

        /**
         * <p>
         * The event type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>error</code> - An error with the Spot fleet request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fleetRequestChange</code> - A change in the status or configuration of the Spot fleet request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instanceChange</code> - An instance was launched or terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Information</code> - An informational event.
         * </p>
         * </li>
         * </ul>
         * 
         * @param eventType
         *        The event type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>error</code> - An error with the Spot fleet request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fleetRequestChange</code> - A change in the status or configuration of the Spot fleet request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instanceChange</code> - An instance was launched or terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Information</code> - An informational event.
         *        </p>
         *        </li>
         * @see EventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * The event type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>error</code> - An error with the Spot fleet request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fleetRequestChange</code> - A change in the status or configuration of the Spot fleet request.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instanceChange</code> - An instance was launched or terminated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Information</code> - An informational event.
         * </p>
         * </li>
         * </ul>
         * 
         * @param eventType
         *        The event type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>error</code> - An error with the Spot fleet request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fleetRequestChange</code> - A change in the status or configuration of the Spot fleet request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instanceChange</code> - An instance was launched or terminated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Information</code> - An informational event.
         *        </p>
         *        </li>
         * @see EventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventType
         */
        Builder eventType(EventType eventType);

        /**
         * <p>
         * The date and time of the event, in UTC format (for example,
         * <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
         * </p>
         * 
         * @param timestamp
         *        The date and time of the event, in UTC format (for example,
         *        <i>YYYY</i>-<i>MM</i>-<i>DD</i>T<i>HH</i>:<i>MM</i>:<i>SS</i>Z).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);
    }

    static final class BuilderImpl implements Builder {
        private EventInformation eventInformation;

        private String eventType;

        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(HistoryRecord model) {
            eventInformation(model.eventInformation);
            eventType(model.eventType);
            timestamp(model.timestamp);
        }

        public final EventInformation.Builder getEventInformation() {
            return eventInformation != null ? eventInformation.toBuilder() : null;
        }

        @Override
        public final Builder eventInformation(EventInformation eventInformation) {
            this.eventInformation = eventInformation;
            return this;
        }

        public final void setEventInformation(EventInformation.BuilderImpl eventInformation) {
            this.eventInformation = eventInformation != null ? eventInformation.build() : null;
        }

        public final String getEventType() {
            return eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(EventType eventType) {
            this.eventType(eventType.toString());
            return this;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public HistoryRecord build() {
            return new HistoryRecord(this);
        }
    }
}
