/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetHostReservationPurchasePreviewResponse extends EC2Response implements
        ToCopyableBuilder<GetHostReservationPurchasePreviewResponse.Builder, GetHostReservationPurchasePreviewResponse> {
    private final String currencyCode;

    private final List<Purchase> purchase;

    private final String totalHourlyPrice;

    private final String totalUpfrontPrice;

    private GetHostReservationPurchasePreviewResponse(BuilderImpl builder) {
        super(builder);
        this.currencyCode = builder.currencyCode;
        this.purchase = builder.purchase;
        this.totalHourlyPrice = builder.totalHourlyPrice;
        this.totalUpfrontPrice = builder.totalUpfrontPrice;
    }

    /**
     * <p>
     * The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are specified.
     * At this time, the only supported currency is <code>USD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are
     *         specified. At this time, the only supported currency is <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(currencyCode);
    }

    /**
     * <p>
     * The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are specified.
     * At this time, the only supported currency is <code>USD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are
     *         specified. At this time, the only supported currency is <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public String currencyCodeAsString() {
        return currencyCode;
    }

    /**
     * <p>
     * The purchase information of the Dedicated Host Reservation and the Dedicated Hosts associated with it.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The purchase information of the Dedicated Host Reservation and the Dedicated Hosts associated with it.
     */
    public List<Purchase> purchase() {
        return purchase;
    }

    /**
     * <p>
     * The potential total hourly price of the reservation per hour.
     * </p>
     * 
     * @return The potential total hourly price of the reservation per hour.
     */
    public String totalHourlyPrice() {
        return totalHourlyPrice;
    }

    /**
     * <p>
     * The potential total upfront price. This is billed immediately.
     * </p>
     * 
     * @return The potential total upfront price. This is billed immediately.
     */
    public String totalUpfrontPrice() {
        return totalUpfrontPrice;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(currencyCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(purchase());
        hashCode = 31 * hashCode + Objects.hashCode(totalHourlyPrice());
        hashCode = 31 * hashCode + Objects.hashCode(totalUpfrontPrice());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHostReservationPurchasePreviewResponse)) {
            return false;
        }
        GetHostReservationPurchasePreviewResponse other = (GetHostReservationPurchasePreviewResponse) obj;
        return Objects.equals(currencyCodeAsString(), other.currencyCodeAsString())
                && Objects.equals(purchase(), other.purchase()) && Objects.equals(totalHourlyPrice(), other.totalHourlyPrice())
                && Objects.equals(totalUpfrontPrice(), other.totalUpfrontPrice());
    }

    @Override
    public String toString() {
        return ToString.builder("GetHostReservationPurchasePreviewResponse").add("CurrencyCode", currencyCodeAsString())
                .add("Purchase", purchase()).add("TotalHourlyPrice", totalHourlyPrice())
                .add("TotalUpfrontPrice", totalUpfrontPrice()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CurrencyCode":
            return Optional.of(clazz.cast(currencyCodeAsString()));
        case "Purchase":
            return Optional.of(clazz.cast(purchase()));
        case "TotalHourlyPrice":
            return Optional.of(clazz.cast(totalHourlyPrice()));
        case "TotalUpfrontPrice":
            return Optional.of(clazz.cast(totalUpfrontPrice()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, GetHostReservationPurchasePreviewResponse> {
        /**
         * <p>
         * The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are
         * specified. At this time, the only supported currency is <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are
         *        specified. At this time, the only supported currency is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are
         * specified. At this time, the only supported currency is <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency in which the <code>totalUpfrontPrice</code> and <code>totalHourlyPrice</code> amounts are
         *        specified. At this time, the only supported currency is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(CurrencyCodeValues currencyCode);

        /**
         * <p>
         * The purchase information of the Dedicated Host Reservation and the Dedicated Hosts associated with it.
         * </p>
         * 
         * @param purchase
         *        The purchase information of the Dedicated Host Reservation and the Dedicated Hosts associated with it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder purchase(Collection<Purchase> purchase);

        /**
         * <p>
         * The purchase information of the Dedicated Host Reservation and the Dedicated Hosts associated with it.
         * </p>
         * 
         * @param purchase
         *        The purchase information of the Dedicated Host Reservation and the Dedicated Hosts associated with it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder purchase(Purchase... purchase);

        /**
         * <p>
         * The purchase information of the Dedicated Host Reservation and the Dedicated Hosts associated with it.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Purchase>.Builder} avoiding the need to
         * create one manually via {@link List<Purchase>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Purchase>.Builder#build()} is called immediately and its
         * result is passed to {@link #purchase(List<Purchase>)}.
         * 
         * @param purchase
         *        a consumer that will call methods on {@link List<Purchase>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #purchase(List<Purchase>)
         */
        Builder purchase(Consumer<Purchase.Builder>... purchase);

        /**
         * <p>
         * The potential total hourly price of the reservation per hour.
         * </p>
         * 
         * @param totalHourlyPrice
         *        The potential total hourly price of the reservation per hour.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalHourlyPrice(String totalHourlyPrice);

        /**
         * <p>
         * The potential total upfront price. This is billed immediately.
         * </p>
         * 
         * @param totalUpfrontPrice
         *        The potential total upfront price. This is billed immediately.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalUpfrontPrice(String totalUpfrontPrice);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private String currencyCode;

        private List<Purchase> purchase;

        private String totalHourlyPrice;

        private String totalUpfrontPrice;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHostReservationPurchasePreviewResponse model) {
            super(model);
            currencyCode(model.currencyCode);
            purchase(model.purchase);
            totalHourlyPrice(model.totalHourlyPrice);
            totalUpfrontPrice(model.totalUpfrontPrice);
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Collection<Purchase.Builder> getPurchase() {
            return purchase != null ? purchase.stream().map(Purchase::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder purchase(Collection<Purchase> purchase) {
            this.purchase = PurchaseSetCopier.copy(purchase);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder purchase(Purchase... purchase) {
            purchase(Arrays.asList(purchase));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder purchase(Consumer<Purchase.Builder>... purchase) {
            purchase(Stream.of(purchase).map(c -> Purchase.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPurchase(Collection<Purchase.BuilderImpl> purchase) {
            this.purchase = PurchaseSetCopier.copyFromBuilder(purchase);
        }

        public final String getTotalHourlyPrice() {
            return totalHourlyPrice;
        }

        @Override
        public final Builder totalHourlyPrice(String totalHourlyPrice) {
            this.totalHourlyPrice = totalHourlyPrice;
            return this;
        }

        public final void setTotalHourlyPrice(String totalHourlyPrice) {
            this.totalHourlyPrice = totalHourlyPrice;
        }

        public final String getTotalUpfrontPrice() {
            return totalUpfrontPrice;
        }

        @Override
        public final Builder totalUpfrontPrice(String totalUpfrontPrice) {
            this.totalUpfrontPrice = totalUpfrontPrice;
            return this;
        }

        public final void setTotalUpfrontPrice(String totalUpfrontPrice) {
            this.totalUpfrontPrice = totalUpfrontPrice;
        }

        @Override
        public GetHostReservationPurchasePreviewResponse build() {
            return new GetHostReservationPurchasePreviewResponse(this);
        }
    }
}
