/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetConsoleScreenshotResponse extends EC2Response implements
        ToCopyableBuilder<GetConsoleScreenshotResponse.Builder, GetConsoleScreenshotResponse> {
    private final String imageData;

    private final String instanceId;

    private GetConsoleScreenshotResponse(BuilderImpl builder) {
        super(builder);
        this.imageData = builder.imageData;
        this.instanceId = builder.instanceId;
    }

    /**
     * <p>
     * The data that comprises the image.
     * </p>
     * 
     * @return The data that comprises the image.
     */
    public String imageData() {
        return imageData;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageData());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConsoleScreenshotResponse)) {
            return false;
        }
        GetConsoleScreenshotResponse other = (GetConsoleScreenshotResponse) obj;
        return Objects.equals(imageData(), other.imageData()) && Objects.equals(instanceId(), other.instanceId());
    }

    @Override
    public String toString() {
        return ToString.builder("GetConsoleScreenshotResponse").add("ImageData", imageData()).add("InstanceId", instanceId())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageData":
            return Optional.of(clazz.cast(imageData()));
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, GetConsoleScreenshotResponse> {
        /**
         * <p>
         * The data that comprises the image.
         * </p>
         * 
         * @param imageData
         *        The data that comprises the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageData(String imageData);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private String imageData;

        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConsoleScreenshotResponse model) {
            super(model);
            imageData(model.imageData);
            instanceId(model.instanceId);
        }

        public final String getImageData() {
            return imageData;
        }

        @Override
        public final Builder imageData(String imageData) {
            this.imageData = imageData;
            return this;
        }

        public final void setImageData(String imageData) {
            this.imageData = imageData;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public GetConsoleScreenshotResponse build() {
            return new GetConsoleScreenshotResponse(this);
        }
    }
}
