/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Elastic GPU.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ElasticGpus implements ToCopyableBuilder<ElasticGpus.Builder, ElasticGpus> {
    private final String elasticGpuId;

    private final String availabilityZone;

    private final String elasticGpuType;

    private final ElasticGpuHealth elasticGpuHealth;

    private final String elasticGpuState;

    private final String instanceId;

    private ElasticGpus(BuilderImpl builder) {
        this.elasticGpuId = builder.elasticGpuId;
        this.availabilityZone = builder.availabilityZone;
        this.elasticGpuType = builder.elasticGpuType;
        this.elasticGpuHealth = builder.elasticGpuHealth;
        this.elasticGpuState = builder.elasticGpuState;
        this.instanceId = builder.instanceId;
    }

    /**
     * <p>
     * The ID of the Elastic GPU.
     * </p>
     * 
     * @return The ID of the Elastic GPU.
     */
    public String elasticGpuId() {
        return elasticGpuId;
    }

    /**
     * <p>
     * The Availability Zone in the which the Elastic GPU resides.
     * </p>
     * 
     * @return The Availability Zone in the which the Elastic GPU resides.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The type of Elastic GPU.
     * </p>
     * 
     * @return The type of Elastic GPU.
     */
    public String elasticGpuType() {
        return elasticGpuType;
    }

    /**
     * <p>
     * The status of the Elastic GPU.
     * </p>
     * 
     * @return The status of the Elastic GPU.
     */
    public ElasticGpuHealth elasticGpuHealth() {
        return elasticGpuHealth;
    }

    /**
     * <p>
     * The state of the Elastic GPU.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #elasticGpuState}
     * will return {@link ElasticGpuState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #elasticGpuStateAsString}.
     * </p>
     * 
     * @return The state of the Elastic GPU.
     * @see ElasticGpuState
     */
    public ElasticGpuState elasticGpuState() {
        return ElasticGpuState.fromValue(elasticGpuState);
    }

    /**
     * <p>
     * The state of the Elastic GPU.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #elasticGpuState}
     * will return {@link ElasticGpuState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #elasticGpuStateAsString}.
     * </p>
     * 
     * @return The state of the Elastic GPU.
     * @see ElasticGpuState
     */
    public String elasticGpuStateAsString() {
        return elasticGpuState;
    }

    /**
     * <p>
     * The ID of the instance to which the Elastic GPU is attached.
     * </p>
     * 
     * @return The ID of the instance to which the Elastic GPU is attached.
     */
    public String instanceId() {
        return instanceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(elasticGpuId());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(elasticGpuType());
        hashCode = 31 * hashCode + Objects.hashCode(elasticGpuHealth());
        hashCode = 31 * hashCode + Objects.hashCode(elasticGpuStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticGpus)) {
            return false;
        }
        ElasticGpus other = (ElasticGpus) obj;
        return Objects.equals(elasticGpuId(), other.elasticGpuId())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(elasticGpuType(), other.elasticGpuType())
                && Objects.equals(elasticGpuHealth(), other.elasticGpuHealth())
                && Objects.equals(elasticGpuStateAsString(), other.elasticGpuStateAsString())
                && Objects.equals(instanceId(), other.instanceId());
    }

    @Override
    public String toString() {
        return ToString.builder("ElasticGpus").add("ElasticGpuId", elasticGpuId()).add("AvailabilityZone", availabilityZone())
                .add("ElasticGpuType", elasticGpuType()).add("ElasticGpuHealth", elasticGpuHealth())
                .add("ElasticGpuState", elasticGpuStateAsString()).add("InstanceId", instanceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ElasticGpuId":
            return Optional.of(clazz.cast(elasticGpuId()));
        case "AvailabilityZone":
            return Optional.of(clazz.cast(availabilityZone()));
        case "ElasticGpuType":
            return Optional.of(clazz.cast(elasticGpuType()));
        case "ElasticGpuHealth":
            return Optional.of(clazz.cast(elasticGpuHealth()));
        case "ElasticGpuState":
            return Optional.of(clazz.cast(elasticGpuStateAsString()));
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ElasticGpus> {
        /**
         * <p>
         * The ID of the Elastic GPU.
         * </p>
         * 
         * @param elasticGpuId
         *        The ID of the Elastic GPU.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuId(String elasticGpuId);

        /**
         * <p>
         * The Availability Zone in the which the Elastic GPU resides.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone in the which the Elastic GPU resides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The type of Elastic GPU.
         * </p>
         * 
         * @param elasticGpuType
         *        The type of Elastic GPU.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuType(String elasticGpuType);

        /**
         * <p>
         * The status of the Elastic GPU.
         * </p>
         * 
         * @param elasticGpuHealth
         *        The status of the Elastic GPU.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticGpuHealth(ElasticGpuHealth elasticGpuHealth);

        /**
         * <p>
         * The status of the Elastic GPU.
         * </p>
         * This is a convenience that creates an instance of the {@link ElasticGpuHealth.Builder} avoiding the need to
         * create one manually via {@link ElasticGpuHealth#builder()}.
         *
         * When the {@link Consumer} completes, {@link ElasticGpuHealth.Builder#build()} is called immediately and its
         * result is passed to {@link #elasticGpuHealth(ElasticGpuHealth)}.
         * 
         * @param elasticGpuHealth
         *        a consumer that will call methods on {@link ElasticGpuHealth.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticGpuHealth(ElasticGpuHealth)
         */
        default Builder elasticGpuHealth(Consumer<ElasticGpuHealth.Builder> elasticGpuHealth) {
            return elasticGpuHealth(ElasticGpuHealth.builder().apply(elasticGpuHealth).build());
        }

        /**
         * <p>
         * The state of the Elastic GPU.
         * </p>
         * 
         * @param elasticGpuState
         *        The state of the Elastic GPU.
         * @see ElasticGpuState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ElasticGpuState
         */
        Builder elasticGpuState(String elasticGpuState);

        /**
         * <p>
         * The state of the Elastic GPU.
         * </p>
         * 
         * @param elasticGpuState
         *        The state of the Elastic GPU.
         * @see ElasticGpuState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ElasticGpuState
         */
        Builder elasticGpuState(ElasticGpuState elasticGpuState);

        /**
         * <p>
         * The ID of the instance to which the Elastic GPU is attached.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance to which the Elastic GPU is attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);
    }

    static final class BuilderImpl implements Builder {
        private String elasticGpuId;

        private String availabilityZone;

        private String elasticGpuType;

        private ElasticGpuHealth elasticGpuHealth;

        private String elasticGpuState;

        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticGpus model) {
            elasticGpuId(model.elasticGpuId);
            availabilityZone(model.availabilityZone);
            elasticGpuType(model.elasticGpuType);
            elasticGpuHealth(model.elasticGpuHealth);
            elasticGpuState(model.elasticGpuState);
            instanceId(model.instanceId);
        }

        public final String getElasticGpuId() {
            return elasticGpuId;
        }

        @Override
        public final Builder elasticGpuId(String elasticGpuId) {
            this.elasticGpuId = elasticGpuId;
            return this;
        }

        public final void setElasticGpuId(String elasticGpuId) {
            this.elasticGpuId = elasticGpuId;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getElasticGpuType() {
            return elasticGpuType;
        }

        @Override
        public final Builder elasticGpuType(String elasticGpuType) {
            this.elasticGpuType = elasticGpuType;
            return this;
        }

        public final void setElasticGpuType(String elasticGpuType) {
            this.elasticGpuType = elasticGpuType;
        }

        public final ElasticGpuHealth.Builder getElasticGpuHealth() {
            return elasticGpuHealth != null ? elasticGpuHealth.toBuilder() : null;
        }

        @Override
        public final Builder elasticGpuHealth(ElasticGpuHealth elasticGpuHealth) {
            this.elasticGpuHealth = elasticGpuHealth;
            return this;
        }

        public final void setElasticGpuHealth(ElasticGpuHealth.BuilderImpl elasticGpuHealth) {
            this.elasticGpuHealth = elasticGpuHealth != null ? elasticGpuHealth.build() : null;
        }

        public final String getElasticGpuState() {
            return elasticGpuState;
        }

        @Override
        public final Builder elasticGpuState(String elasticGpuState) {
            this.elasticGpuState = elasticGpuState;
            return this;
        }

        @Override
        public final Builder elasticGpuState(ElasticGpuState elasticGpuState) {
            this.elasticGpuState(elasticGpuState.toString());
            return this;
        }

        public final void setElasticGpuState(String elasticGpuState) {
            this.elasticGpuState = elasticGpuState;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public ElasticGpus build() {
            return new ElasticGpus(this);
        }
    }
}
