/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DisassociateIamInstanceProfileResponse extends EC2Response implements
        ToCopyableBuilder<DisassociateIamInstanceProfileResponse.Builder, DisassociateIamInstanceProfileResponse> {
    private final IamInstanceProfileAssociation iamInstanceProfileAssociation;

    private DisassociateIamInstanceProfileResponse(BuilderImpl builder) {
        super(builder);
        this.iamInstanceProfileAssociation = builder.iamInstanceProfileAssociation;
    }

    /**
     * <p>
     * Information about the IAM instance profile association.
     * </p>
     * 
     * @return Information about the IAM instance profile association.
     */
    public IamInstanceProfileAssociation iamInstanceProfileAssociation() {
        return iamInstanceProfileAssociation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iamInstanceProfileAssociation());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateIamInstanceProfileResponse)) {
            return false;
        }
        DisassociateIamInstanceProfileResponse other = (DisassociateIamInstanceProfileResponse) obj;
        return Objects.equals(iamInstanceProfileAssociation(), other.iamInstanceProfileAssociation());
    }

    @Override
    public String toString() {
        return ToString.builder("DisassociateIamInstanceProfileResponse")
                .add("IamInstanceProfileAssociation", iamInstanceProfileAssociation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IamInstanceProfileAssociation":
            return Optional.of(clazz.cast(iamInstanceProfileAssociation()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DisassociateIamInstanceProfileResponse> {
        /**
         * <p>
         * Information about the IAM instance profile association.
         * </p>
         * 
         * @param iamInstanceProfileAssociation
         *        Information about the IAM instance profile association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfileAssociation(IamInstanceProfileAssociation iamInstanceProfileAssociation);

        /**
         * <p>
         * Information about the IAM instance profile association.
         * </p>
         * This is a convenience that creates an instance of the {@link IamInstanceProfileAssociation.Builder} avoiding
         * the need to create one manually via {@link IamInstanceProfileAssociation#builder()}.
         *
         * When the {@link Consumer} completes, {@link IamInstanceProfileAssociation.Builder#build()} is called
         * immediately and its result is passed to {@link #iamInstanceProfileAssociation(IamInstanceProfileAssociation)}
         * .
         * 
         * @param iamInstanceProfileAssociation
         *        a consumer that will call methods on {@link IamInstanceProfileAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamInstanceProfileAssociation(IamInstanceProfileAssociation)
         */
        default Builder iamInstanceProfileAssociation(
                Consumer<IamInstanceProfileAssociation.Builder> iamInstanceProfileAssociation) {
            return iamInstanceProfileAssociation(IamInstanceProfileAssociation.builder().apply(iamInstanceProfileAssociation)
                    .build());
        }
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private IamInstanceProfileAssociation iamInstanceProfileAssociation;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateIamInstanceProfileResponse model) {
            super(model);
            iamInstanceProfileAssociation(model.iamInstanceProfileAssociation);
        }

        public final IamInstanceProfileAssociation.Builder getIamInstanceProfileAssociation() {
            return iamInstanceProfileAssociation != null ? iamInstanceProfileAssociation.toBuilder() : null;
        }

        @Override
        public final Builder iamInstanceProfileAssociation(IamInstanceProfileAssociation iamInstanceProfileAssociation) {
            this.iamInstanceProfileAssociation = iamInstanceProfileAssociation;
            return this;
        }

        public final void setIamInstanceProfileAssociation(IamInstanceProfileAssociation.BuilderImpl iamInstanceProfileAssociation) {
            this.iamInstanceProfileAssociation = iamInstanceProfileAssociation != null ? iamInstanceProfileAssociation.build()
                    : null;
        }

        @Override
        public DisassociateIamInstanceProfileResponse build() {
            return new DisassociateIamInstanceProfileResponse(this);
        }
    }
}
