/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeVolumeStatus.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeVolumeStatusResponse extends EC2Response implements
        ToCopyableBuilder<DescribeVolumeStatusResponse.Builder, DescribeVolumeStatusResponse> {
    private final String nextToken;

    private final List<VolumeStatusItem> volumeStatuses;

    private DescribeVolumeStatusResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.volumeStatuses = builder.volumeStatuses;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * A list of volumes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of volumes.
     */
    public List<VolumeStatusItem> volumeStatuses() {
        return volumeStatuses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(volumeStatuses());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVolumeStatusResponse)) {
            return false;
        }
        DescribeVolumeStatusResponse other = (DescribeVolumeStatusResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(volumeStatuses(), other.volumeStatuses());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeVolumeStatusResponse").add("NextToken", nextToken())
                .add("VolumeStatuses", volumeStatuses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "VolumeStatuses":
            return Optional.of(clazz.cast(volumeStatuses()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeVolumeStatusResponse> {
        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of volumes.
         * </p>
         * 
         * @param volumeStatuses
         *        A list of volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeStatuses(Collection<VolumeStatusItem> volumeStatuses);

        /**
         * <p>
         * A list of volumes.
         * </p>
         * 
         * @param volumeStatuses
         *        A list of volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeStatuses(VolumeStatusItem... volumeStatuses);

        /**
         * <p>
         * A list of volumes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VolumeStatusItem>.Builder} avoiding the
         * need to create one manually via {@link List<VolumeStatusItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VolumeStatusItem>.Builder#build()} is called immediately and
         * its result is passed to {@link #volumeStatuses(List<VolumeStatusItem>)}.
         * 
         * @param volumeStatuses
         *        a consumer that will call methods on {@link List<VolumeStatusItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumeStatuses(List<VolumeStatusItem>)
         */
        Builder volumeStatuses(Consumer<VolumeStatusItem.Builder>... volumeStatuses);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<VolumeStatusItem> volumeStatuses;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVolumeStatusResponse model) {
            super(model);
            nextToken(model.nextToken);
            volumeStatuses(model.volumeStatuses);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<VolumeStatusItem.Builder> getVolumeStatuses() {
            return volumeStatuses != null ? volumeStatuses.stream().map(VolumeStatusItem::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder volumeStatuses(Collection<VolumeStatusItem> volumeStatuses) {
            this.volumeStatuses = VolumeStatusListCopier.copy(volumeStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeStatuses(VolumeStatusItem... volumeStatuses) {
            volumeStatuses(Arrays.asList(volumeStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeStatuses(Consumer<VolumeStatusItem.Builder>... volumeStatuses) {
            volumeStatuses(Stream.of(volumeStatuses).map(c -> VolumeStatusItem.builder().apply(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setVolumeStatuses(Collection<VolumeStatusItem.BuilderImpl> volumeStatuses) {
            this.volumeStatuses = VolumeStatusListCopier.copyFromBuilder(volumeStatuses);
        }

        @Override
        public DescribeVolumeStatusResponse build() {
            return new DescribeVolumeStatusResponse(this);
        }
    }
}
