/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeTags.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeTagsResponse extends EC2Response implements
        ToCopyableBuilder<DescribeTagsResponse.Builder, DescribeTagsResponse> {
    private final String nextToken;

    private final List<TagDescription> tags;

    private DescribeTagsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return..
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return..
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * A list of tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of tags.
     */
    public List<TagDescription> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTagsResponse)) {
            return false;
        }
        DescribeTagsResponse other = (DescribeTagsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(tags(), other.tags());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeTagsResponse").add("NextToken", nextToken()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "Tags":
            return Optional.of(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeTagsResponse> {
        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return..
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of tags.
         * </p>
         * 
         * @param tags
         *        A list of tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<TagDescription> tags);

        /**
         * <p>
         * A list of tags.
         * </p>
         * 
         * @param tags
         *        A list of tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(TagDescription... tags);

        /**
         * <p>
         * A list of tags.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagDescription>.Builder} avoiding the need
         * to create one manually via {@link List<TagDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagDescription>.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<TagDescription>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<TagDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<TagDescription>)
         */
        Builder tags(Consumer<TagDescription.Builder>... tags);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<TagDescription> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTagsResponse model) {
            super(model);
            nextToken(model.nextToken);
            tags(model.tags);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<TagDescription.Builder> getTags() {
            return tags != null ? tags.stream().map(TagDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<TagDescription> tags) {
            this.tags = TagDescriptionListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagDescription... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagDescription.Builder>... tags) {
            tags(Stream.of(tags).map(c -> TagDescription.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<TagDescription.BuilderImpl> tags) {
            this.tags = TagDescriptionListCopier.copyFromBuilder(tags);
        }

        @Override
        public DescribeTagsResponse build() {
            return new DescribeTagsResponse(this);
        }
    }
}
