/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeSubnets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeSubnetsResponse extends EC2Response implements
        ToCopyableBuilder<DescribeSubnetsResponse.Builder, DescribeSubnetsResponse> {
    private final List<Subnet> subnets;

    private DescribeSubnetsResponse(BuilderImpl builder) {
        super(builder);
        this.subnets = builder.subnets;
    }

    /**
     * <p>
     * Information about one or more subnets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more subnets.
     */
    public List<Subnet> subnets() {
        return subnets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subnets());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSubnetsResponse)) {
            return false;
        }
        DescribeSubnetsResponse other = (DescribeSubnetsResponse) obj;
        return Objects.equals(subnets(), other.subnets());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeSubnetsResponse").add("Subnets", subnets()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Subnets":
            return Optional.of(clazz.cast(subnets()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeSubnetsResponse> {
        /**
         * <p>
         * Information about one or more subnets.
         * </p>
         * 
         * @param subnets
         *        Information about one or more subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(Collection<Subnet> subnets);

        /**
         * <p>
         * Information about one or more subnets.
         * </p>
         * 
         * @param subnets
         *        Information about one or more subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnets(Subnet... subnets);

        /**
         * <p>
         * Information about one or more subnets.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Subnet>.Builder} avoiding the need to
         * create one manually via {@link List<Subnet>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Subnet>.Builder#build()} is called immediately and its
         * result is passed to {@link #subnets(List<Subnet>)}.
         * 
         * @param subnets
         *        a consumer that will call methods on {@link List<Subnet>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subnets(List<Subnet>)
         */
        Builder subnets(Consumer<Subnet.Builder>... subnets);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<Subnet> subnets;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSubnetsResponse model) {
            super(model);
            subnets(model.subnets);
        }

        public final Collection<Subnet.Builder> getSubnets() {
            return subnets != null ? subnets.stream().map(Subnet::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subnets(Collection<Subnet> subnets) {
            this.subnets = SubnetListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(Subnet... subnets) {
            subnets(Arrays.asList(subnets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(Consumer<Subnet.Builder>... subnets) {
            subnets(Stream.of(subnets).map(c -> Subnet.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSubnets(Collection<Subnet.BuilderImpl> subnets) {
            this.subnets = SubnetListCopier.copyFromBuilder(subnets);
        }

        @Override
        public DescribeSubnetsResponse build() {
            return new DescribeSubnetsResponse(this);
        }
    }
}
