/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeSnapshots.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeSnapshotsResponse extends EC2Response implements
        ToCopyableBuilder<DescribeSnapshotsResponse.Builder, DescribeSnapshotsResponse> {
    private final List<Snapshot> snapshots;

    private final String nextToken;

    private DescribeSnapshotsResponse(BuilderImpl builder) {
        super(builder);
        this.snapshots = builder.snapshots;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the snapshots.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the snapshots.
     */
    public List<Snapshot> snapshots() {
        return snapshots;
    }

    /**
     * <p>
     * The <code>NextToken</code> value to include in a future <code>DescribeSnapshots</code> request. When the results
     * of a <code>DescribeSnapshots</code> request exceed <code>MaxResults</code>, this value can be used to retrieve
     * the next page of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>NextToken</code> value to include in a future <code>DescribeSnapshots</code> request. When the
     *         results of a <code>DescribeSnapshots</code> request exceed <code>MaxResults</code>, this value can be
     *         used to retrieve the next page of results. This value is <code>null</code> when there are no more results
     *         to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(snapshots());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotsResponse)) {
            return false;
        }
        DescribeSnapshotsResponse other = (DescribeSnapshotsResponse) obj;
        return Objects.equals(snapshots(), other.snapshots()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeSnapshotsResponse").add("Snapshots", snapshots()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Snapshots":
            return Optional.of(clazz.cast(snapshots()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeSnapshotsResponse> {
        /**
         * <p>
         * Information about the snapshots.
         * </p>
         * 
         * @param snapshots
         *        Information about the snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshots(Collection<Snapshot> snapshots);

        /**
         * <p>
         * Information about the snapshots.
         * </p>
         * 
         * @param snapshots
         *        Information about the snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshots(Snapshot... snapshots);

        /**
         * <p>
         * Information about the snapshots.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Snapshot>.Builder} avoiding the need to
         * create one manually via {@link List<Snapshot>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Snapshot>.Builder#build()} is called immediately and its
         * result is passed to {@link #snapshots(List<Snapshot>)}.
         * 
         * @param snapshots
         *        a consumer that will call methods on {@link List<Snapshot>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snapshots(List<Snapshot>)
         */
        Builder snapshots(Consumer<Snapshot.Builder>... snapshots);

        /**
         * <p>
         * The <code>NextToken</code> value to include in a future <code>DescribeSnapshots</code> request. When the
         * results of a <code>DescribeSnapshots</code> request exceed <code>MaxResults</code>, this value can be used to
         * retrieve the next page of results. This value is <code>null</code> when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>NextToken</code> value to include in a future <code>DescribeSnapshots</code> request. When
         *        the results of a <code>DescribeSnapshots</code> request exceed <code>MaxResults</code>, this value can
         *        be used to retrieve the next page of results. This value is <code>null</code> when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<Snapshot> snapshots;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotsResponse model) {
            super(model);
            snapshots(model.snapshots);
            nextToken(model.nextToken);
        }

        public final Collection<Snapshot.Builder> getSnapshots() {
            return snapshots != null ? snapshots.stream().map(Snapshot::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder snapshots(Collection<Snapshot> snapshots) {
            this.snapshots = SnapshotListCopier.copy(snapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshots(Snapshot... snapshots) {
            snapshots(Arrays.asList(snapshots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshots(Consumer<Snapshot.Builder>... snapshots) {
            snapshots(Stream.of(snapshots).map(c -> Snapshot.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSnapshots(Collection<Snapshot.BuilderImpl> snapshots) {
            this.snapshots = SnapshotListCopier.copyFromBuilder(snapshots);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeSnapshotsResponse build() {
            return new DescribeSnapshotsResponse(this);
        }
    }
}
