/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeScheduledInstanceAvailability.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeScheduledInstanceAvailabilityRequest extends EC2Request implements
        ToCopyableBuilder<DescribeScheduledInstanceAvailabilityRequest.Builder, DescribeScheduledInstanceAvailabilityRequest> {
    private final List<Filter> filters;

    private final SlotDateTimeRangeRequest firstSlotStartTimeRange;

    private final Integer maxResults;

    private final Integer maxSlotDurationInHours;

    private final Integer minSlotDurationInHours;

    private final String nextToken;

    private final ScheduledInstanceRecurrenceRequest recurrence;

    private DescribeScheduledInstanceAvailabilityRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.firstSlotStartTimeRange = builder.firstSlotStartTimeRange;
        this.maxResults = builder.maxResults;
        this.maxSlotDurationInHours = builder.maxSlotDurationInHours;
        this.minSlotDurationInHours = builder.minSlotDurationInHours;
        this.nextToken = builder.nextToken;
        this.recurrence = builder.recurrence;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The time period for the first schedule to start.
     * </p>
     * 
     * @return The time period for the first schedule to start.
     */
    public SlotDateTimeRangeRequest firstSlotStartTimeRange() {
        return firstSlotStartTimeRange;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. This value can be between 5 and 300. The default value
     * is 300. To retrieve the remaining results, make another call with the returned <code>NextToken</code> value.
     * </p>
     * 
     * @return The maximum number of results to return in a single call. This value can be between 5 and 300. The
     *         default value is 300. To retrieve the remaining results, make another call with the returned
     *         <code>NextToken</code> value.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The maximum available duration, in hours. This value must be greater than <code>MinSlotDurationInHours</code> and
     * less than 1,720.
     * </p>
     * 
     * @return The maximum available duration, in hours. This value must be greater than
     *         <code>MinSlotDurationInHours</code> and less than 1,720.
     */
    public Integer maxSlotDurationInHours() {
        return maxSlotDurationInHours;
    }

    /**
     * <p>
     * The minimum available duration, in hours. The minimum required duration is 1,200 hours per year. For example, the
     * minimum daily schedule is 4 hours, the minimum weekly schedule is 24 hours, and the minimum monthly schedule is
     * 100 hours.
     * </p>
     * 
     * @return The minimum available duration, in hours. The minimum required duration is 1,200 hours per year. For
     *         example, the minimum daily schedule is 4 hours, the minimum weekly schedule is 24 hours, and the minimum
     *         monthly schedule is 100 hours.
     */
    public Integer minSlotDurationInHours() {
        return minSlotDurationInHours;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     * 
     * @return The token for the next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The schedule recurrence.
     * </p>
     * 
     * @return The schedule recurrence.
     */
    public ScheduledInstanceRecurrenceRequest recurrence() {
        return recurrence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(firstSlotStartTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(maxSlotDurationInHours());
        hashCode = 31 * hashCode + Objects.hashCode(minSlotDurationInHours());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(recurrence());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledInstanceAvailabilityRequest)) {
            return false;
        }
        DescribeScheduledInstanceAvailabilityRequest other = (DescribeScheduledInstanceAvailabilityRequest) obj;
        return Objects.equals(filters(), other.filters())
                && Objects.equals(firstSlotStartTimeRange(), other.firstSlotStartTimeRange())
                && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(maxSlotDurationInHours(), other.maxSlotDurationInHours())
                && Objects.equals(minSlotDurationInHours(), other.minSlotDurationInHours())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(recurrence(), other.recurrence());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeScheduledInstanceAvailabilityRequest").add("Filters", filters())
                .add("FirstSlotStartTimeRange", firstSlotStartTimeRange()).add("MaxResults", maxResults())
                .add("MaxSlotDurationInHours", maxSlotDurationInHours()).add("MinSlotDurationInHours", minSlotDurationInHours())
                .add("NextToken", nextToken()).add("Recurrence", recurrence()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        case "FirstSlotStartTimeRange":
            return Optional.of(clazz.cast(firstSlotStartTimeRange()));
        case "MaxResults":
            return Optional.of(clazz.cast(maxResults()));
        case "MaxSlotDurationInHours":
            return Optional.of(clazz.cast(maxSlotDurationInHours()));
        case "MinSlotDurationInHours":
            return Optional.of(clazz.cast(minSlotDurationInHours()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "Recurrence":
            return Optional.of(clazz.cast(recurrence()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, DescribeScheduledInstanceAvailabilityRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>
         *        ).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>
         *        ).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone (for example, <code>us-west-2a</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-type</code> - The instance type (for example, <code>c4.large</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-platform</code> - The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>platform</code> - The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The time period for the first schedule to start.
         * </p>
         * 
         * @param firstSlotStartTimeRange
         *        The time period for the first schedule to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstSlotStartTimeRange(SlotDateTimeRangeRequest firstSlotStartTimeRange);

        /**
         * <p>
         * The time period for the first schedule to start.
         * </p>
         * This is a convenience that creates an instance of the {@link SlotDateTimeRangeRequest.Builder} avoiding the
         * need to create one manually via {@link SlotDateTimeRangeRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link SlotDateTimeRangeRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #firstSlotStartTimeRange(SlotDateTimeRangeRequest)}.
         * 
         * @param firstSlotStartTimeRange
         *        a consumer that will call methods on {@link SlotDateTimeRangeRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firstSlotStartTimeRange(SlotDateTimeRangeRequest)
         */
        default Builder firstSlotStartTimeRange(Consumer<SlotDateTimeRangeRequest.Builder> firstSlotStartTimeRange) {
            return firstSlotStartTimeRange(SlotDateTimeRangeRequest.builder().apply(firstSlotStartTimeRange).build());
        }

        /**
         * <p>
         * The maximum number of results to return in a single call. This value can be between 5 and 300. The default
         * value is 300. To retrieve the remaining results, make another call with the returned <code>NextToken</code>
         * value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call. This value can be between 5 and 300. The
         *        default value is 300. To retrieve the remaining results, make another call with the returned
         *        <code>NextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The maximum available duration, in hours. This value must be greater than <code>MinSlotDurationInHours</code>
         * and less than 1,720.
         * </p>
         * 
         * @param maxSlotDurationInHours
         *        The maximum available duration, in hours. This value must be greater than
         *        <code>MinSlotDurationInHours</code> and less than 1,720.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSlotDurationInHours(Integer maxSlotDurationInHours);

        /**
         * <p>
         * The minimum available duration, in hours. The minimum required duration is 1,200 hours per year. For example,
         * the minimum daily schedule is 4 hours, the minimum weekly schedule is 24 hours, and the minimum monthly
         * schedule is 100 hours.
         * </p>
         * 
         * @param minSlotDurationInHours
         *        The minimum available duration, in hours. The minimum required duration is 1,200 hours per year. For
         *        example, the minimum daily schedule is 4 hours, the minimum weekly schedule is 24 hours, and the
         *        minimum monthly schedule is 100 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minSlotDurationInHours(Integer minSlotDurationInHours);

        /**
         * <p>
         * The token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The schedule recurrence.
         * </p>
         * 
         * @param recurrence
         *        The schedule recurrence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurrence(ScheduledInstanceRecurrenceRequest recurrence);

        /**
         * <p>
         * The schedule recurrence.
         * </p>
         * This is a convenience that creates an instance of the {@link ScheduledInstanceRecurrenceRequest.Builder}
         * avoiding the need to create one manually via {@link ScheduledInstanceRecurrenceRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link ScheduledInstanceRecurrenceRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #recurrence(ScheduledInstanceRecurrenceRequest)}.
         * 
         * @param recurrence
         *        a consumer that will call methods on {@link ScheduledInstanceRecurrenceRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recurrence(ScheduledInstanceRecurrenceRequest)
         */
        default Builder recurrence(Consumer<ScheduledInstanceRecurrenceRequest.Builder> recurrence) {
            return recurrence(ScheduledInstanceRecurrenceRequest.builder().apply(recurrence).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private List<Filter> filters;

        private SlotDateTimeRangeRequest firstSlotStartTimeRange;

        private Integer maxResults;

        private Integer maxSlotDurationInHours;

        private Integer minSlotDurationInHours;

        private String nextToken;

        private ScheduledInstanceRecurrenceRequest recurrence;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledInstanceAvailabilityRequest model) {
            super(model);
            filters(model.filters);
            firstSlotStartTimeRange(model.firstSlotStartTimeRange);
            maxResults(model.maxResults);
            maxSlotDurationInHours(model.maxSlotDurationInHours);
            minSlotDurationInHours(model.minSlotDurationInHours);
            nextToken(model.nextToken);
            recurrence(model.recurrence);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final SlotDateTimeRangeRequest.Builder getFirstSlotStartTimeRange() {
            return firstSlotStartTimeRange != null ? firstSlotStartTimeRange.toBuilder() : null;
        }

        @Override
        public final Builder firstSlotStartTimeRange(SlotDateTimeRangeRequest firstSlotStartTimeRange) {
            this.firstSlotStartTimeRange = firstSlotStartTimeRange;
            return this;
        }

        public final void setFirstSlotStartTimeRange(SlotDateTimeRangeRequest.BuilderImpl firstSlotStartTimeRange) {
            this.firstSlotStartTimeRange = firstSlotStartTimeRange != null ? firstSlotStartTimeRange.build() : null;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Integer getMaxSlotDurationInHours() {
            return maxSlotDurationInHours;
        }

        @Override
        public final Builder maxSlotDurationInHours(Integer maxSlotDurationInHours) {
            this.maxSlotDurationInHours = maxSlotDurationInHours;
            return this;
        }

        public final void setMaxSlotDurationInHours(Integer maxSlotDurationInHours) {
            this.maxSlotDurationInHours = maxSlotDurationInHours;
        }

        public final Integer getMinSlotDurationInHours() {
            return minSlotDurationInHours;
        }

        @Override
        public final Builder minSlotDurationInHours(Integer minSlotDurationInHours) {
            this.minSlotDurationInHours = minSlotDurationInHours;
            return this;
        }

        public final void setMinSlotDurationInHours(Integer minSlotDurationInHours) {
            this.minSlotDurationInHours = minSlotDurationInHours;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final ScheduledInstanceRecurrenceRequest.Builder getRecurrence() {
            return recurrence != null ? recurrence.toBuilder() : null;
        }

        @Override
        public final Builder recurrence(ScheduledInstanceRecurrenceRequest recurrence) {
            this.recurrence = recurrence;
            return this;
        }

        public final void setRecurrence(ScheduledInstanceRecurrenceRequest.BuilderImpl recurrence) {
            this.recurrence = recurrence != null ? recurrence.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeScheduledInstanceAvailabilityRequest build() {
            return new DescribeScheduledInstanceAvailabilityRequest(this);
        }
    }
}
