/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribePrefixLists.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribePrefixListsResponse extends EC2Response implements
        ToCopyableBuilder<DescribePrefixListsResponse.Builder, DescribePrefixListsResponse> {
    private final String nextToken;

    private final List<PrefixList> prefixLists;

    private DescribePrefixListsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.prefixLists = builder.prefixLists;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * All available prefix lists.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return All available prefix lists.
     */
    public List<PrefixList> prefixLists() {
        return prefixLists;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(prefixLists());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePrefixListsResponse)) {
            return false;
        }
        DescribePrefixListsResponse other = (DescribePrefixListsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(prefixLists(), other.prefixLists());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribePrefixListsResponse").add("NextToken", nextToken()).add("PrefixLists", prefixLists())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "PrefixLists":
            return Optional.of(clazz.cast(prefixLists()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribePrefixListsResponse> {
        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * All available prefix lists.
         * </p>
         * 
         * @param prefixLists
         *        All available prefix lists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixLists(Collection<PrefixList> prefixLists);

        /**
         * <p>
         * All available prefix lists.
         * </p>
         * 
         * @param prefixLists
         *        All available prefix lists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixLists(PrefixList... prefixLists);

        /**
         * <p>
         * All available prefix lists.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PrefixList>.Builder} avoiding the need to
         * create one manually via {@link List<PrefixList>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PrefixList>.Builder#build()} is called immediately and its
         * result is passed to {@link #prefixLists(List<PrefixList>)}.
         * 
         * @param prefixLists
         *        a consumer that will call methods on {@link List<PrefixList>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #prefixLists(List<PrefixList>)
         */
        Builder prefixLists(Consumer<PrefixList.Builder>... prefixLists);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<PrefixList> prefixLists;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePrefixListsResponse model) {
            super(model);
            nextToken(model.nextToken);
            prefixLists(model.prefixLists);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<PrefixList.Builder> getPrefixLists() {
            return prefixLists != null ? prefixLists.stream().map(PrefixList::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder prefixLists(Collection<PrefixList> prefixLists) {
            this.prefixLists = PrefixListSetCopier.copy(prefixLists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prefixLists(PrefixList... prefixLists) {
            prefixLists(Arrays.asList(prefixLists));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prefixLists(Consumer<PrefixList.Builder>... prefixLists) {
            prefixLists(Stream.of(prefixLists).map(c -> PrefixList.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPrefixLists(Collection<PrefixList.BuilderImpl> prefixLists) {
            this.prefixLists = PrefixListSetCopier.copyFromBuilder(prefixLists);
        }

        @Override
        public DescribePrefixListsResponse build() {
            return new DescribePrefixListsResponse(this);
        }
    }
}
