/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeNetworkInterfaceAttribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeNetworkInterfaceAttributeResponse extends EC2Response implements
        ToCopyableBuilder<DescribeNetworkInterfaceAttributeResponse.Builder, DescribeNetworkInterfaceAttributeResponse> {
    private final NetworkInterfaceAttachment attachment;

    private final String description;

    private final List<GroupIdentifier> groups;

    private final String networkInterfaceId;

    private final Boolean sourceDestCheck;

    private DescribeNetworkInterfaceAttributeResponse(BuilderImpl builder) {
        super(builder);
        this.attachment = builder.attachment;
        this.description = builder.description;
        this.groups = builder.groups;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.sourceDestCheck = builder.sourceDestCheck;
    }

    /**
     * <p>
     * The attachment (if any) of the network interface.
     * </p>
     * 
     * @return The attachment (if any) of the network interface.
     */
    public NetworkInterfaceAttachment attachment() {
        return attachment;
    }

    /**
     * <p>
     * The description of the network interface.
     * </p>
     * 
     * @return The description of the network interface.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The security groups associated with the network interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The security groups associated with the network interface.
     */
    public List<GroupIdentifier> groups() {
        return groups;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * Indicates whether source/destination checking is enabled.
     * </p>
     * 
     * @return Indicates whether source/destination checking is enabled.
     */
    public Boolean sourceDestCheck() {
        return sourceDestCheck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachment());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(groups());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceDestCheck());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkInterfaceAttributeResponse)) {
            return false;
        }
        DescribeNetworkInterfaceAttributeResponse other = (DescribeNetworkInterfaceAttributeResponse) obj;
        return Objects.equals(attachment(), other.attachment()) && Objects.equals(description(), other.description())
                && Objects.equals(groups(), other.groups()) && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(sourceDestCheck(), other.sourceDestCheck());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeNetworkInterfaceAttributeResponse").add("Attachment", attachment())
                .add("Description", description()).add("Groups", groups()).add("NetworkInterfaceId", networkInterfaceId())
                .add("SourceDestCheck", sourceDestCheck()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attachment":
            return Optional.of(clazz.cast(attachment()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "Groups":
            return Optional.of(clazz.cast(groups()));
        case "NetworkInterfaceId":
            return Optional.of(clazz.cast(networkInterfaceId()));
        case "SourceDestCheck":
            return Optional.of(clazz.cast(sourceDestCheck()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeNetworkInterfaceAttributeResponse> {
        /**
         * <p>
         * The attachment (if any) of the network interface.
         * </p>
         * 
         * @param attachment
         *        The attachment (if any) of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachment(NetworkInterfaceAttachment attachment);

        /**
         * <p>
         * The attachment (if any) of the network interface.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkInterfaceAttachment.Builder} avoiding the
         * need to create one manually via {@link NetworkInterfaceAttachment#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkInterfaceAttachment.Builder#build()} is called immediately
         * and its result is passed to {@link #attachment(NetworkInterfaceAttachment)}.
         * 
         * @param attachment
         *        a consumer that will call methods on {@link NetworkInterfaceAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachment(NetworkInterfaceAttachment)
         */
        default Builder attachment(Consumer<NetworkInterfaceAttachment.Builder> attachment) {
            return attachment(NetworkInterfaceAttachment.builder().apply(attachment).build());
        }

        /**
         * <p>
         * The description of the network interface.
         * </p>
         * 
         * @param description
         *        The description of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The security groups associated with the network interface.
         * </p>
         * 
         * @param groups
         *        The security groups associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<GroupIdentifier> groups);

        /**
         * <p>
         * The security groups associated with the network interface.
         * </p>
         * 
         * @param groups
         *        The security groups associated with the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(GroupIdentifier... groups);

        /**
         * <p>
         * The security groups associated with the network interface.
         * </p>
         * This is a convenience that creates an instance of the {@link List<GroupIdentifier>.Builder} avoiding the need
         * to create one manually via {@link List<GroupIdentifier>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GroupIdentifier>.Builder#build()} is called immediately and
         * its result is passed to {@link #groups(List<GroupIdentifier>)}.
         * 
         * @param groups
         *        a consumer that will call methods on {@link List<GroupIdentifier>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groups(List<GroupIdentifier>)
         */
        Builder groups(Consumer<GroupIdentifier.Builder>... groups);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * Indicates whether source/destination checking is enabled.
         * </p>
         * 
         * @param sourceDestCheck
         *        Indicates whether source/destination checking is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDestCheck(Boolean sourceDestCheck);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private NetworkInterfaceAttachment attachment;

        private String description;

        private List<GroupIdentifier> groups;

        private String networkInterfaceId;

        private Boolean sourceDestCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNetworkInterfaceAttributeResponse model) {
            super(model);
            attachment(model.attachment);
            description(model.description);
            groups(model.groups);
            networkInterfaceId(model.networkInterfaceId);
            sourceDestCheck(model.sourceDestCheck);
        }

        public final NetworkInterfaceAttachment.Builder getAttachment() {
            return attachment != null ? attachment.toBuilder() : null;
        }

        @Override
        public final Builder attachment(NetworkInterfaceAttachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public final void setAttachment(NetworkInterfaceAttachment.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<GroupIdentifier.Builder> getGroups() {
            return groups != null ? groups.stream().map(GroupIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groups(Collection<GroupIdentifier> groups) {
            this.groups = GroupIdentifierListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupIdentifier... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<GroupIdentifier.Builder>... groups) {
            groups(Stream.of(groups).map(c -> GroupIdentifier.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGroups(Collection<GroupIdentifier.BuilderImpl> groups) {
            this.groups = GroupIdentifierListCopier.copyFromBuilder(groups);
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final Boolean getSourceDestCheck() {
            return sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final void setSourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        @Override
        public DescribeNetworkInterfaceAttributeResponse build() {
            return new DescribeNetworkInterfaceAttributeResponse(this);
        }
    }
}
