/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeNatGateways.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeNatGatewaysResponse extends EC2Response implements
        ToCopyableBuilder<DescribeNatGatewaysResponse.Builder, DescribeNatGatewaysResponse> {
    private final List<NatGateway> natGateways;

    private final String nextToken;

    private DescribeNatGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.natGateways = builder.natGateways;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the NAT gateways.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the NAT gateways.
     */
    public List<NatGateway> natGateways() {
        return natGateways;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(natGateways());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNatGatewaysResponse)) {
            return false;
        }
        DescribeNatGatewaysResponse other = (DescribeNatGatewaysResponse) obj;
        return Objects.equals(natGateways(), other.natGateways()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeNatGatewaysResponse").add("NatGateways", natGateways()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NatGateways":
            return Optional.of(clazz.cast(natGateways()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeNatGatewaysResponse> {
        /**
         * <p>
         * Information about the NAT gateways.
         * </p>
         * 
         * @param natGateways
         *        Information about the NAT gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder natGateways(Collection<NatGateway> natGateways);

        /**
         * <p>
         * Information about the NAT gateways.
         * </p>
         * 
         * @param natGateways
         *        Information about the NAT gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder natGateways(NatGateway... natGateways);

        /**
         * <p>
         * Information about the NAT gateways.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NatGateway>.Builder} avoiding the need to
         * create one manually via {@link List<NatGateway>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NatGateway>.Builder#build()} is called immediately and its
         * result is passed to {@link #natGateways(List<NatGateway>)}.
         * 
         * @param natGateways
         *        a consumer that will call methods on {@link List<NatGateway>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #natGateways(List<NatGateway>)
         */
        Builder natGateways(Consumer<NatGateway.Builder>... natGateways);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<NatGateway> natGateways;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNatGatewaysResponse model) {
            super(model);
            natGateways(model.natGateways);
            nextToken(model.nextToken);
        }

        public final Collection<NatGateway.Builder> getNatGateways() {
            return natGateways != null ? natGateways.stream().map(NatGateway::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder natGateways(Collection<NatGateway> natGateways) {
            this.natGateways = NatGatewayListCopier.copy(natGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder natGateways(NatGateway... natGateways) {
            natGateways(Arrays.asList(natGateways));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder natGateways(Consumer<NatGateway.Builder>... natGateways) {
            natGateways(Stream.of(natGateways).map(c -> NatGateway.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNatGateways(Collection<NatGateway.BuilderImpl> natGateways) {
            this.natGateways = NatGatewayListCopier.copyFromBuilder(natGateways);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeNatGatewaysResponse build() {
            return new DescribeNatGatewaysResponse(this);
        }
    }
}
