/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeImages.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeImagesResponse extends EC2Response implements
        ToCopyableBuilder<DescribeImagesResponse.Builder, DescribeImagesResponse> {
    private final List<Image> images;

    private DescribeImagesResponse(BuilderImpl builder) {
        super(builder);
        this.images = builder.images;
    }

    /**
     * <p>
     * Information about one or more images.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more images.
     */
    public List<Image> images() {
        return images;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(images());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImagesResponse)) {
            return false;
        }
        DescribeImagesResponse other = (DescribeImagesResponse) obj;
        return Objects.equals(images(), other.images());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeImagesResponse").add("Images", images()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Images":
            return Optional.of(clazz.cast(images()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeImagesResponse> {
        /**
         * <p>
         * Information about one or more images.
         * </p>
         * 
         * @param images
         *        Information about one or more images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder images(Collection<Image> images);

        /**
         * <p>
         * Information about one or more images.
         * </p>
         * 
         * @param images
         *        Information about one or more images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder images(Image... images);

        /**
         * <p>
         * Information about one or more images.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Image>.Builder} avoiding the need to create
         * one manually via {@link List<Image>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Image>.Builder#build()} is called immediately and its result
         * is passed to {@link #images(List<Image>)}.
         * 
         * @param images
         *        a consumer that will call methods on {@link List<Image>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #images(List<Image>)
         */
        Builder images(Consumer<Image.Builder>... images);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<Image> images;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImagesResponse model) {
            super(model);
            images(model.images);
        }

        public final Collection<Image.Builder> getImages() {
            return images != null ? images.stream().map(Image::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder images(Collection<Image> images) {
            this.images = ImageListCopier.copy(images);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(Image... images) {
            images(Arrays.asList(images));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(Consumer<Image.Builder>... images) {
            images(Stream.of(images).map(c -> Image.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setImages(Collection<Image.BuilderImpl> images) {
            this.images = ImageListCopier.copyFromBuilder(images);
        }

        @Override
        public DescribeImagesResponse build() {
            return new DescribeImagesResponse(this);
        }
    }
}
