/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeIamInstanceProfileAssociationsResponse extends EC2Response implements
        ToCopyableBuilder<DescribeIamInstanceProfileAssociationsResponse.Builder, DescribeIamInstanceProfileAssociationsResponse> {
    private final List<IamInstanceProfileAssociation> iamInstanceProfileAssociations;

    private final String nextToken;

    private DescribeIamInstanceProfileAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.iamInstanceProfileAssociations = builder.iamInstanceProfileAssociations;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about one or more IAM instance profile associations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more IAM instance profile associations.
     */
    public List<IamInstanceProfileAssociation> iamInstanceProfileAssociations() {
        return iamInstanceProfileAssociations;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iamInstanceProfileAssociations());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIamInstanceProfileAssociationsResponse)) {
            return false;
        }
        DescribeIamInstanceProfileAssociationsResponse other = (DescribeIamInstanceProfileAssociationsResponse) obj;
        return Objects.equals(iamInstanceProfileAssociations(), other.iamInstanceProfileAssociations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeIamInstanceProfileAssociationsResponse")
                .add("IamInstanceProfileAssociations", iamInstanceProfileAssociations()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IamInstanceProfileAssociations":
            return Optional.of(clazz.cast(iamInstanceProfileAssociations()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder,
            CopyableBuilder<Builder, DescribeIamInstanceProfileAssociationsResponse> {
        /**
         * <p>
         * Information about one or more IAM instance profile associations.
         * </p>
         * 
         * @param iamInstanceProfileAssociations
         *        Information about one or more IAM instance profile associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfileAssociations(Collection<IamInstanceProfileAssociation> iamInstanceProfileAssociations);

        /**
         * <p>
         * Information about one or more IAM instance profile associations.
         * </p>
         * 
         * @param iamInstanceProfileAssociations
         *        Information about one or more IAM instance profile associations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamInstanceProfileAssociations(IamInstanceProfileAssociation... iamInstanceProfileAssociations);

        /**
         * <p>
         * Information about one or more IAM instance profile associations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IamInstanceProfileAssociation>.Builder}
         * avoiding the need to create one manually via {@link List<IamInstanceProfileAssociation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IamInstanceProfileAssociation>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #iamInstanceProfileAssociations(List<IamInstanceProfileAssociation>)}.
         * 
         * @param iamInstanceProfileAssociations
         *        a consumer that will call methods on {@link List<IamInstanceProfileAssociation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamInstanceProfileAssociations(List<IamInstanceProfileAssociation>)
         */
        Builder iamInstanceProfileAssociations(Consumer<IamInstanceProfileAssociation.Builder>... iamInstanceProfileAssociations);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<IamInstanceProfileAssociation> iamInstanceProfileAssociations;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIamInstanceProfileAssociationsResponse model) {
            super(model);
            iamInstanceProfileAssociations(model.iamInstanceProfileAssociations);
            nextToken(model.nextToken);
        }

        public final Collection<IamInstanceProfileAssociation.Builder> getIamInstanceProfileAssociations() {
            return iamInstanceProfileAssociations != null ? iamInstanceProfileAssociations.stream()
                    .map(IamInstanceProfileAssociation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder iamInstanceProfileAssociations(
                Collection<IamInstanceProfileAssociation> iamInstanceProfileAssociations) {
            this.iamInstanceProfileAssociations = IamInstanceProfileAssociationSetCopier.copy(iamInstanceProfileAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iamInstanceProfileAssociations(IamInstanceProfileAssociation... iamInstanceProfileAssociations) {
            iamInstanceProfileAssociations(Arrays.asList(iamInstanceProfileAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iamInstanceProfileAssociations(
                Consumer<IamInstanceProfileAssociation.Builder>... iamInstanceProfileAssociations) {
            iamInstanceProfileAssociations(Stream.of(iamInstanceProfileAssociations)
                    .map(c -> IamInstanceProfileAssociation.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIamInstanceProfileAssociations(
                Collection<IamInstanceProfileAssociation.BuilderImpl> iamInstanceProfileAssociations) {
            this.iamInstanceProfileAssociations = IamInstanceProfileAssociationSetCopier
                    .copyFromBuilder(iamInstanceProfileAssociations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeIamInstanceProfileAssociationsResponse build() {
            return new DescribeIamInstanceProfileAssociationsResponse(this);
        }
    }
}
