/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeFpgaImageAttributeRequest extends EC2Request implements
        ToCopyableBuilder<DescribeFpgaImageAttributeRequest.Builder, DescribeFpgaImageAttributeRequest> {
    private final String fpgaImageId;

    private final String attribute;

    private DescribeFpgaImageAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.fpgaImageId = builder.fpgaImageId;
        this.attribute = builder.attribute;
    }

    /**
     * <p>
     * The ID of the AFI.
     * </p>
     * 
     * @return The ID of the AFI.
     */
    public String fpgaImageId() {
        return fpgaImageId;
    }

    /**
     * <p>
     * The AFI attribute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link FpgaImageAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attributeAsString}.
     * </p>
     * 
     * @return The AFI attribute.
     * @see FpgaImageAttributeName
     */
    public FpgaImageAttributeName attribute() {
        return FpgaImageAttributeName.fromValue(attribute);
    }

    /**
     * <p>
     * The AFI attribute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link FpgaImageAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attributeAsString}.
     * </p>
     * 
     * @return The AFI attribute.
     * @see FpgaImageAttributeName
     */
    public String attributeAsString() {
        return attribute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fpgaImageId());
        hashCode = 31 * hashCode + Objects.hashCode(attributeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFpgaImageAttributeRequest)) {
            return false;
        }
        DescribeFpgaImageAttributeRequest other = (DescribeFpgaImageAttributeRequest) obj;
        return Objects.equals(fpgaImageId(), other.fpgaImageId())
                && Objects.equals(attributeAsString(), other.attributeAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeFpgaImageAttributeRequest").add("FpgaImageId", fpgaImageId())
                .add("Attribute", attributeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FpgaImageId":
            return Optional.of(clazz.cast(fpgaImageId()));
        case "Attribute":
            return Optional.of(clazz.cast(attributeAsString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, DescribeFpgaImageAttributeRequest> {
        /**
         * <p>
         * The ID of the AFI.
         * </p>
         * 
         * @param fpgaImageId
         *        The ID of the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fpgaImageId(String fpgaImageId);

        /**
         * <p>
         * The AFI attribute.
         * </p>
         * 
         * @param attribute
         *        The AFI attribute.
         * @see FpgaImageAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FpgaImageAttributeName
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The AFI attribute.
         * </p>
         * 
         * @param attribute
         *        The AFI attribute.
         * @see FpgaImageAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FpgaImageAttributeName
         */
        Builder attribute(FpgaImageAttributeName attribute);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String fpgaImageId;

        private String attribute;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFpgaImageAttributeRequest model) {
            super(model);
            fpgaImageId(model.fpgaImageId);
            attribute(model.attribute);
        }

        public final String getFpgaImageId() {
            return fpgaImageId;
        }

        @Override
        public final Builder fpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
            return this;
        }

        public final void setFpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
        }

        public final String getAttribute() {
            return attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(FpgaImageAttributeName attribute) {
            this.attribute(attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeFpgaImageAttributeRequest build() {
            return new DescribeFpgaImageAttributeRequest(this);
        }
    }
}
