/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output for DescribeConversionTasks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeConversionTasksResponse extends EC2Response implements
        ToCopyableBuilder<DescribeConversionTasksResponse.Builder, DescribeConversionTasksResponse> {
    private final List<ConversionTask> conversionTasks;

    private DescribeConversionTasksResponse(BuilderImpl builder) {
        super(builder);
        this.conversionTasks = builder.conversionTasks;
    }

    /**
     * <p>
     * Information about the conversion tasks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the conversion tasks.
     */
    public List<ConversionTask> conversionTasks() {
        return conversionTasks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(conversionTasks());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConversionTasksResponse)) {
            return false;
        }
        DescribeConversionTasksResponse other = (DescribeConversionTasksResponse) obj;
        return Objects.equals(conversionTasks(), other.conversionTasks());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeConversionTasksResponse").add("ConversionTasks", conversionTasks()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConversionTasks":
            return Optional.of(clazz.cast(conversionTasks()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeConversionTasksResponse> {
        /**
         * <p>
         * Information about the conversion tasks.
         * </p>
         * 
         * @param conversionTasks
         *        Information about the conversion tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversionTasks(Collection<ConversionTask> conversionTasks);

        /**
         * <p>
         * Information about the conversion tasks.
         * </p>
         * 
         * @param conversionTasks
         *        Information about the conversion tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversionTasks(ConversionTask... conversionTasks);

        /**
         * <p>
         * Information about the conversion tasks.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ConversionTask>.Builder} avoiding the need
         * to create one manually via {@link List<ConversionTask>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConversionTask>.Builder#build()} is called immediately and
         * its result is passed to {@link #conversionTasks(List<ConversionTask>)}.
         * 
         * @param conversionTasks
         *        a consumer that will call methods on {@link List<ConversionTask>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conversionTasks(List<ConversionTask>)
         */
        Builder conversionTasks(Consumer<ConversionTask.Builder>... conversionTasks);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<ConversionTask> conversionTasks;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConversionTasksResponse model) {
            super(model);
            conversionTasks(model.conversionTasks);
        }

        public final Collection<ConversionTask.Builder> getConversionTasks() {
            return conversionTasks != null ? conversionTasks.stream().map(ConversionTask::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder conversionTasks(Collection<ConversionTask> conversionTasks) {
            this.conversionTasks = DescribeConversionTaskListCopier.copy(conversionTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conversionTasks(ConversionTask... conversionTasks) {
            conversionTasks(Arrays.asList(conversionTasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conversionTasks(Consumer<ConversionTask.Builder>... conversionTasks) {
            conversionTasks(Stream.of(conversionTasks).map(c -> ConversionTask.builder().apply(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setConversionTasks(Collection<ConversionTask.BuilderImpl> conversionTasks) {
            this.conversionTasks = DescribeConversionTaskListCopier.copyFromBuilder(conversionTasks);
        }

        @Override
        public DescribeConversionTasksResponse build() {
            return new DescribeConversionTasksResponse(this);
        }
    }
}
