/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeClassicLinkInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeClassicLinkInstancesResponse extends EC2Response implements
        ToCopyableBuilder<DescribeClassicLinkInstancesResponse.Builder, DescribeClassicLinkInstancesResponse> {
    private final List<ClassicLinkInstance> instances;

    private final String nextToken;

    private DescribeClassicLinkInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.instances = builder.instances;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about one or more linked EC2-Classic instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more linked EC2-Classic instances.
     */
    public List<ClassicLinkInstance> instances() {
        return instances;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instances());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClassicLinkInstancesResponse)) {
            return false;
        }
        DescribeClassicLinkInstancesResponse other = (DescribeClassicLinkInstancesResponse) obj;
        return Objects.equals(instances(), other.instances()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeClassicLinkInstancesResponse").add("Instances", instances())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Instances":
            return Optional.of(clazz.cast(instances()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeClassicLinkInstancesResponse> {
        /**
         * <p>
         * Information about one or more linked EC2-Classic instances.
         * </p>
         * 
         * @param instances
         *        Information about one or more linked EC2-Classic instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Collection<ClassicLinkInstance> instances);

        /**
         * <p>
         * Information about one or more linked EC2-Classic instances.
         * </p>
         * 
         * @param instances
         *        Information about one or more linked EC2-Classic instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(ClassicLinkInstance... instances);

        /**
         * <p>
         * Information about one or more linked EC2-Classic instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ClassicLinkInstance>.Builder} avoiding the
         * need to create one manually via {@link List<ClassicLinkInstance>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ClassicLinkInstance>.Builder#build()} is called immediately
         * and its result is passed to {@link #instances(List<ClassicLinkInstance>)}.
         * 
         * @param instances
         *        a consumer that will call methods on {@link List<ClassicLinkInstance>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instances(List<ClassicLinkInstance>)
         */
        Builder instances(Consumer<ClassicLinkInstance.Builder>... instances);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<ClassicLinkInstance> instances;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClassicLinkInstancesResponse model) {
            super(model);
            instances(model.instances);
            nextToken(model.nextToken);
        }

        public final Collection<ClassicLinkInstance.Builder> getInstances() {
            return instances != null ? instances.stream().map(ClassicLinkInstance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instances(Collection<ClassicLinkInstance> instances) {
            this.instances = ClassicLinkInstanceListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(ClassicLinkInstance... instances) {
            instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<ClassicLinkInstance.Builder>... instances) {
            instances(Stream.of(instances).map(c -> ClassicLinkInstance.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstances(Collection<ClassicLinkInstance.BuilderImpl> instances) {
            this.instances = ClassicLinkInstanceListCopier.copyFromBuilder(instances);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeClassicLinkInstancesResponse build() {
            return new DescribeClassicLinkInstancesResponse(this);
        }
    }
}
