/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DeleteTags.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteTagsRequest extends EC2Request implements ToCopyableBuilder<DeleteTagsRequest.Builder, DeleteTagsRequest> {
    private final List<String> resources;

    private final List<Tag> tags;

    private DeleteTagsRequest(BuilderImpl builder) {
        super(builder);
        this.resources = builder.resources;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The IDs of one or more resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of one or more resources.
     */
    public List<String> resources() {
        return resources;
    }

    /**
     * <p>
     * One or more tags to delete. If you omit this parameter, we delete all tags for the specified resources. Specify a
     * tag key and an optional tag value to delete specific tags. If you specify a tag key without a tag value, we
     * delete any tag with this key regardless of its value. If you specify a tag key with an empty string as the tag
     * value, we delete the tag only if its value is an empty string.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more tags to delete. If you omit this parameter, we delete all tags for the specified resources.
     *         Specify a tag key and an optional tag value to delete specific tags. If you specify a tag key without a
     *         tag value, we delete any tag with this key regardless of its value. If you specify a tag key with an
     *         empty string as the tag value, we delete the tag only if its value is an empty string.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resources());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTagsRequest)) {
            return false;
        }
        DeleteTagsRequest other = (DeleteTagsRequest) obj;
        return Objects.equals(resources(), other.resources()) && Objects.equals(tags(), other.tags());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteTagsRequest").add("Resources", resources()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Resources":
            return Optional.of(clazz.cast(resources()));
        case "Tags":
            return Optional.of(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, DeleteTagsRequest> {
        /**
         * <p>
         * The IDs of one or more resources.
         * </p>
         * 
         * @param resources
         *        The IDs of one or more resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Collection<String> resources);

        /**
         * <p>
         * The IDs of one or more resources.
         * </p>
         * 
         * @param resources
         *        The IDs of one or more resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(String... resources);

        /**
         * <p>
         * One or more tags to delete. If you omit this parameter, we delete all tags for the specified resources.
         * Specify a tag key and an optional tag value to delete specific tags. If you specify a tag key without a tag
         * value, we delete any tag with this key regardless of its value. If you specify a tag key with an empty string
         * as the tag value, we delete the tag only if its value is an empty string.
         * </p>
         * 
         * @param tags
         *        One or more tags to delete. If you omit this parameter, we delete all tags for the specified
         *        resources. Specify a tag key and an optional tag value to delete specific tags. If you specify a tag
         *        key without a tag value, we delete any tag with this key regardless of its value. If you specify a tag
         *        key with an empty string as the tag value, we delete the tag only if its value is an empty string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * One or more tags to delete. If you omit this parameter, we delete all tags for the specified resources.
         * Specify a tag key and an optional tag value to delete specific tags. If you specify a tag key without a tag
         * value, we delete any tag with this key regardless of its value. If you specify a tag key with an empty string
         * as the tag value, we delete the tag only if its value is an empty string.
         * </p>
         * 
         * @param tags
         *        One or more tags to delete. If you omit this parameter, we delete all tags for the specified
         *        resources. Specify a tag key and an optional tag value to delete specific tags. If you specify a tag
         *        key without a tag value, we delete any tag with this key regardless of its value. If you specify a tag
         *        key with an empty string as the tag value, we delete the tag only if its value is an empty string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * One or more tags to delete. If you omit this parameter, we delete all tags for the specified resources.
         * Specify a tag key and an optional tag value to delete specific tags. If you specify a tag key without a tag
         * value, we delete any tag with this key regardless of its value. If you specify a tag key with an empty string
         * as the tag value, we delete the tag only if its value is an empty string.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private List<String> resources;

        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTagsRequest model) {
            super(model);
            resources(model.resources);
            tags(model.tags);
        }

        public final Collection<String> getResources() {
            return resources;
        }

        @Override
        public final Builder resources(Collection<String> resources) {
            this.resources = ResourceIdListCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(String... resources) {
            resources(Arrays.asList(resources));
            return this;
        }

        public final void setResources(Collection<String> resources) {
            this.resources = ResourceIdListCopier.copy(resources);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteTagsRequest build() {
            return new DeleteTagsRequest(this);
        }
    }
}
