/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteEgressOnlyInternetGatewayRequest extends EC2Request implements
        ToCopyableBuilder<DeleteEgressOnlyInternetGatewayRequest.Builder, DeleteEgressOnlyInternetGatewayRequest> {
    private final String egressOnlyInternetGatewayId;

    private DeleteEgressOnlyInternetGatewayRequest(BuilderImpl builder) {
        super(builder);
        this.egressOnlyInternetGatewayId = builder.egressOnlyInternetGatewayId;
    }

    /**
     * <p>
     * The ID of the egress-only Internet gateway.
     * </p>
     * 
     * @return The ID of the egress-only Internet gateway.
     */
    public String egressOnlyInternetGatewayId() {
        return egressOnlyInternetGatewayId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(egressOnlyInternetGatewayId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteEgressOnlyInternetGatewayRequest)) {
            return false;
        }
        DeleteEgressOnlyInternetGatewayRequest other = (DeleteEgressOnlyInternetGatewayRequest) obj;
        return Objects.equals(egressOnlyInternetGatewayId(), other.egressOnlyInternetGatewayId());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteEgressOnlyInternetGatewayRequest")
                .add("EgressOnlyInternetGatewayId", egressOnlyInternetGatewayId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EgressOnlyInternetGatewayId":
            return Optional.of(clazz.cast(egressOnlyInternetGatewayId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, DeleteEgressOnlyInternetGatewayRequest> {
        /**
         * <p>
         * The ID of the egress-only Internet gateway.
         * </p>
         * 
         * @param egressOnlyInternetGatewayId
         *        The ID of the egress-only Internet gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressOnlyInternetGatewayId(String egressOnlyInternetGatewayId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String egressOnlyInternetGatewayId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteEgressOnlyInternetGatewayRequest model) {
            super(model);
            egressOnlyInternetGatewayId(model.egressOnlyInternetGatewayId);
        }

        public final String getEgressOnlyInternetGatewayId() {
            return egressOnlyInternetGatewayId;
        }

        @Override
        public final Builder egressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
            return this;
        }

        public final void setEgressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteEgressOnlyInternetGatewayRequest build() {
            return new DeleteEgressOnlyInternetGatewayRequest(this);
        }
    }
}
