/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CreateVpnConnection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateVpnConnectionRequest extends EC2Request implements
        ToCopyableBuilder<CreateVpnConnectionRequest.Builder, CreateVpnConnectionRequest> {
    private final String customerGatewayId;

    private final String type;

    private final String vpnGatewayId;

    private final VpnConnectionOptionsSpecification options;

    private CreateVpnConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.customerGatewayId = builder.customerGatewayId;
        this.type = builder.type;
        this.vpnGatewayId = builder.vpnGatewayId;
        this.options = builder.options;
    }

    /**
     * <p>
     * The ID of the customer gateway.
     * </p>
     * 
     * @return The ID of the customer gateway.
     */
    public String customerGatewayId() {
        return customerGatewayId;
    }

    /**
     * <p>
     * The type of VPN connection (<code>ipsec.1</code>).
     * </p>
     * 
     * @return The type of VPN connection (<code>ipsec.1</code>).
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * The ID of the virtual private gateway.
     * </p>
     * 
     * @return The ID of the virtual private gateway.
     */
    public String vpnGatewayId() {
        return vpnGatewayId;
    }

    /**
     * <p>
     * The options for the VPN connection.
     * </p>
     * 
     * @return The options for the VPN connection.
     */
    public VpnConnectionOptionsSpecification options() {
        return options;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customerGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(vpnGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(options());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpnConnectionRequest)) {
            return false;
        }
        CreateVpnConnectionRequest other = (CreateVpnConnectionRequest) obj;
        return Objects.equals(customerGatewayId(), other.customerGatewayId()) && Objects.equals(type(), other.type())
                && Objects.equals(vpnGatewayId(), other.vpnGatewayId()) && Objects.equals(options(), other.options());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateVpnConnectionRequest").add("CustomerGatewayId", customerGatewayId()).add("Type", type())
                .add("VpnGatewayId", vpnGatewayId()).add("Options", options()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomerGatewayId":
            return Optional.of(clazz.cast(customerGatewayId()));
        case "Type":
            return Optional.of(clazz.cast(type()));
        case "VpnGatewayId":
            return Optional.of(clazz.cast(vpnGatewayId()));
        case "Options":
            return Optional.of(clazz.cast(options()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, CreateVpnConnectionRequest> {
        /**
         * <p>
         * The ID of the customer gateway.
         * </p>
         * 
         * @param customerGatewayId
         *        The ID of the customer gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerGatewayId(String customerGatewayId);

        /**
         * <p>
         * The type of VPN connection (<code>ipsec.1</code>).
         * </p>
         * 
         * @param type
         *        The type of VPN connection (<code>ipsec.1</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The ID of the virtual private gateway.
         * </p>
         * 
         * @param vpnGatewayId
         *        The ID of the virtual private gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnGatewayId(String vpnGatewayId);

        /**
         * <p>
         * The options for the VPN connection.
         * </p>
         * 
         * @param options
         *        The options for the VPN connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(VpnConnectionOptionsSpecification options);

        /**
         * <p>
         * The options for the VPN connection.
         * </p>
         * This is a convenience that creates an instance of the {@link VpnConnectionOptionsSpecification.Builder}
         * avoiding the need to create one manually via {@link VpnConnectionOptionsSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpnConnectionOptionsSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #options(VpnConnectionOptionsSpecification)}.
         * 
         * @param options
         *        a consumer that will call methods on {@link VpnConnectionOptionsSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(VpnConnectionOptionsSpecification)
         */
        default Builder options(Consumer<VpnConnectionOptionsSpecification.Builder> options) {
            return options(VpnConnectionOptionsSpecification.builder().apply(options).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String customerGatewayId;

        private String type;

        private String vpnGatewayId;

        private VpnConnectionOptionsSpecification options;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpnConnectionRequest model) {
            super(model);
            customerGatewayId(model.customerGatewayId);
            type(model.type);
            vpnGatewayId(model.vpnGatewayId);
            options(model.options);
        }

        public final String getCustomerGatewayId() {
            return customerGatewayId;
        }

        @Override
        public final Builder customerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
            return this;
        }

        public final void setCustomerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getVpnGatewayId() {
            return vpnGatewayId;
        }

        @Override
        public final Builder vpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
            return this;
        }

        public final void setVpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
        }

        public final VpnConnectionOptionsSpecification.Builder getOptions() {
            return options != null ? options.toBuilder() : null;
        }

        @Override
        public final Builder options(VpnConnectionOptionsSpecification options) {
            this.options = options;
            return this;
        }

        public final void setOptions(VpnConnectionOptionsSpecification.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateVpnConnectionRequest build() {
            return new CreateVpnConnectionRequest(this);
        }
    }
}
