/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CreateReservedInstancesListing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateReservedInstancesListingResponse extends EC2Response implements
        ToCopyableBuilder<CreateReservedInstancesListingResponse.Builder, CreateReservedInstancesListingResponse> {
    private final List<ReservedInstancesListing> reservedInstancesListings;

    private CreateReservedInstancesListingResponse(BuilderImpl builder) {
        super(builder);
        this.reservedInstancesListings = builder.reservedInstancesListings;
    }

    /**
     * <p>
     * Information about the Standard Reserved Instance listing.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the Standard Reserved Instance listing.
     */
    public List<ReservedInstancesListing> reservedInstancesListings() {
        return reservedInstancesListings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesListings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReservedInstancesListingResponse)) {
            return false;
        }
        CreateReservedInstancesListingResponse other = (CreateReservedInstancesListingResponse) obj;
        return Objects.equals(reservedInstancesListings(), other.reservedInstancesListings());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateReservedInstancesListingResponse")
                .add("ReservedInstancesListings", reservedInstancesListings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedInstancesListings":
            return Optional.of(clazz.cast(reservedInstancesListings()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, CreateReservedInstancesListingResponse> {
        /**
         * <p>
         * Information about the Standard Reserved Instance listing.
         * </p>
         * 
         * @param reservedInstancesListings
         *        Information about the Standard Reserved Instance listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesListings(Collection<ReservedInstancesListing> reservedInstancesListings);

        /**
         * <p>
         * Information about the Standard Reserved Instance listing.
         * </p>
         * 
         * @param reservedInstancesListings
         *        Information about the Standard Reserved Instance listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesListings(ReservedInstancesListing... reservedInstancesListings);

        /**
         * <p>
         * Information about the Standard Reserved Instance listing.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReservedInstancesListing>.Builder} avoiding
         * the need to create one manually via {@link List<ReservedInstancesListing>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReservedInstancesListing>.Builder#build()} is called
         * immediately and its result is passed to {@link #reservedInstancesListings(List<ReservedInstancesListing>)}.
         * 
         * @param reservedInstancesListings
         *        a consumer that will call methods on {@link List<ReservedInstancesListing>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservedInstancesListings(List<ReservedInstancesListing>)
         */
        Builder reservedInstancesListings(Consumer<ReservedInstancesListing.Builder>... reservedInstancesListings);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<ReservedInstancesListing> reservedInstancesListings;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReservedInstancesListingResponse model) {
            super(model);
            reservedInstancesListings(model.reservedInstancesListings);
        }

        public final Collection<ReservedInstancesListing.Builder> getReservedInstancesListings() {
            return reservedInstancesListings != null ? reservedInstancesListings.stream()
                    .map(ReservedInstancesListing::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedInstancesListings(Collection<ReservedInstancesListing> reservedInstancesListings) {
            this.reservedInstancesListings = ReservedInstancesListingListCopier.copy(reservedInstancesListings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesListings(ReservedInstancesListing... reservedInstancesListings) {
            reservedInstancesListings(Arrays.asList(reservedInstancesListings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesListings(Consumer<ReservedInstancesListing.Builder>... reservedInstancesListings) {
            reservedInstancesListings(Stream.of(reservedInstancesListings)
                    .map(c -> ReservedInstancesListing.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReservedInstancesListings(Collection<ReservedInstancesListing.BuilderImpl> reservedInstancesListings) {
            this.reservedInstancesListings = ReservedInstancesListingListCopier.copyFromBuilder(reservedInstancesListings);
        }

        @Override
        public CreateReservedInstancesListingResponse build() {
            return new CreateReservedInstancesListingResponse(this);
        }
    }
}
