/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CreateInternetGateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateInternetGatewayResponse extends EC2Response implements
        ToCopyableBuilder<CreateInternetGatewayResponse.Builder, CreateInternetGatewayResponse> {
    private final InternetGateway internetGateway;

    private CreateInternetGatewayResponse(BuilderImpl builder) {
        super(builder);
        this.internetGateway = builder.internetGateway;
    }

    /**
     * <p>
     * Information about the Internet gateway.
     * </p>
     * 
     * @return Information about the Internet gateway.
     */
    public InternetGateway internetGateway() {
        return internetGateway;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(internetGateway());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInternetGatewayResponse)) {
            return false;
        }
        CreateInternetGatewayResponse other = (CreateInternetGatewayResponse) obj;
        return Objects.equals(internetGateway(), other.internetGateway());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateInternetGatewayResponse").add("InternetGateway", internetGateway()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InternetGateway":
            return Optional.of(clazz.cast(internetGateway()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, CreateInternetGatewayResponse> {
        /**
         * <p>
         * Information about the Internet gateway.
         * </p>
         * 
         * @param internetGateway
         *        Information about the Internet gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internetGateway(InternetGateway internetGateway);

        /**
         * <p>
         * Information about the Internet gateway.
         * </p>
         * This is a convenience that creates an instance of the {@link InternetGateway.Builder} avoiding the need to
         * create one manually via {@link InternetGateway#builder()}.
         *
         * When the {@link Consumer} completes, {@link InternetGateway.Builder#build()} is called immediately and its
         * result is passed to {@link #internetGateway(InternetGateway)}.
         * 
         * @param internetGateway
         *        a consumer that will call methods on {@link InternetGateway.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #internetGateway(InternetGateway)
         */
        default Builder internetGateway(Consumer<InternetGateway.Builder> internetGateway) {
            return internetGateway(InternetGateway.builder().apply(internetGateway).build());
        }
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private InternetGateway internetGateway;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInternetGatewayResponse model) {
            super(model);
            internetGateway(model.internetGateway);
        }

        public final InternetGateway.Builder getInternetGateway() {
            return internetGateway != null ? internetGateway.toBuilder() : null;
        }

        @Override
        public final Builder internetGateway(InternetGateway internetGateway) {
            this.internetGateway = internetGateway;
            return this;
        }

        public final void setInternetGateway(InternetGateway.BuilderImpl internetGateway) {
            this.internetGateway = internetGateway != null ? internetGateway.build() : null;
        }

        @Override
        public CreateInternetGatewayResponse build() {
            return new CreateInternetGatewayResponse(this);
        }
    }
}
