/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CopyFpgaImageRequest extends EC2Request implements
        ToCopyableBuilder<CopyFpgaImageRequest.Builder, CopyFpgaImageRequest> {
    private final String sourceFpgaImageId;

    private final String description;

    private final String name;

    private final String sourceRegion;

    private final String clientToken;

    private CopyFpgaImageRequest(BuilderImpl builder) {
        super(builder);
        this.sourceFpgaImageId = builder.sourceFpgaImageId;
        this.description = builder.description;
        this.name = builder.name;
        this.sourceRegion = builder.sourceRegion;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of the source AFI.
     * </p>
     * 
     * @return The ID of the source AFI.
     */
    public String sourceFpgaImageId() {
        return sourceFpgaImageId;
    }

    /**
     * <p>
     * The description for the new AFI.
     * </p>
     * 
     * @return The description for the new AFI.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The name for the new AFI. The default is the name of the source AFI.
     * </p>
     * 
     * @return The name for the new AFI. The default is the name of the source AFI.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The region that contains the source AFI.
     * </p>
     * 
     * @return The region that contains the source AFI.
     */
    public String sourceRegion() {
        return sourceRegion;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">Ensuring Idempotency</a>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceFpgaImageId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(sourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyFpgaImageRequest)) {
            return false;
        }
        CopyFpgaImageRequest other = (CopyFpgaImageRequest) obj;
        return Objects.equals(sourceFpgaImageId(), other.sourceFpgaImageId())
                && Objects.equals(description(), other.description()) && Objects.equals(name(), other.name())
                && Objects.equals(sourceRegion(), other.sourceRegion()) && Objects.equals(clientToken(), other.clientToken());
    }

    @Override
    public String toString() {
        return ToString.builder("CopyFpgaImageRequest").add("SourceFpgaImageId", sourceFpgaImageId())
                .add("Description", description()).add("Name", name()).add("SourceRegion", sourceRegion())
                .add("ClientToken", clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceFpgaImageId":
            return Optional.of(clazz.cast(sourceFpgaImageId()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "SourceRegion":
            return Optional.of(clazz.cast(sourceRegion()));
        case "ClientToken":
            return Optional.of(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, CopyFpgaImageRequest> {
        /**
         * <p>
         * The ID of the source AFI.
         * </p>
         * 
         * @param sourceFpgaImageId
         *        The ID of the source AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceFpgaImageId(String sourceFpgaImageId);

        /**
         * <p>
         * The description for the new AFI.
         * </p>
         * 
         * @param description
         *        The description for the new AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name for the new AFI. The default is the name of the source AFI.
         * </p>
         * 
         * @param name
         *        The name for the new AFI. The default is the name of the source AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The region that contains the source AFI.
         * </p>
         * 
         * @param sourceRegion
         *        The region that contains the source AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRegion(String sourceRegion);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String sourceFpgaImageId;

        private String description;

        private String name;

        private String sourceRegion;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyFpgaImageRequest model) {
            super(model);
            sourceFpgaImageId(model.sourceFpgaImageId);
            description(model.description);
            name(model.name);
            sourceRegion(model.sourceRegion);
            clientToken(model.clientToken);
        }

        public final String getSourceFpgaImageId() {
            return sourceFpgaImageId;
        }

        @Override
        public final Builder sourceFpgaImageId(String sourceFpgaImageId) {
            this.sourceFpgaImageId = sourceFpgaImageId;
            return this;
        }

        public final void setSourceFpgaImageId(String sourceFpgaImageId) {
            this.sourceFpgaImageId = sourceFpgaImageId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getSourceRegion() {
            return sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CopyFpgaImageRequest build() {
            return new CopyFpgaImageRequest(this);
        }
    }
}
