/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CancelImportTask.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CancelImportTaskRequest extends EC2Request implements
        ToCopyableBuilder<CancelImportTaskRequest.Builder, CancelImportTaskRequest> {
    private final String cancelReason;

    private final String importTaskId;

    private CancelImportTaskRequest(BuilderImpl builder) {
        super(builder);
        this.cancelReason = builder.cancelReason;
        this.importTaskId = builder.importTaskId;
    }

    /**
     * <p>
     * The reason for canceling the task.
     * </p>
     * 
     * @return The reason for canceling the task.
     */
    public String cancelReason() {
        return cancelReason;
    }

    /**
     * <p>
     * The ID of the import image or import snapshot task to be canceled.
     * </p>
     * 
     * @return The ID of the import image or import snapshot task to be canceled.
     */
    public String importTaskId() {
        return importTaskId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cancelReason());
        hashCode = 31 * hashCode + Objects.hashCode(importTaskId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelImportTaskRequest)) {
            return false;
        }
        CancelImportTaskRequest other = (CancelImportTaskRequest) obj;
        return Objects.equals(cancelReason(), other.cancelReason()) && Objects.equals(importTaskId(), other.importTaskId());
    }

    @Override
    public String toString() {
        return ToString.builder("CancelImportTaskRequest").add("CancelReason", cancelReason())
                .add("ImportTaskId", importTaskId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CancelReason":
            return Optional.of(clazz.cast(cancelReason()));
        case "ImportTaskId":
            return Optional.of(clazz.cast(importTaskId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, CancelImportTaskRequest> {
        /**
         * <p>
         * The reason for canceling the task.
         * </p>
         * 
         * @param cancelReason
         *        The reason for canceling the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancelReason(String cancelReason);

        /**
         * <p>
         * The ID of the import image or import snapshot task to be canceled.
         * </p>
         * 
         * @param importTaskId
         *        The ID of the import image or import snapshot task to be canceled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importTaskId(String importTaskId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String cancelReason;

        private String importTaskId;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelImportTaskRequest model) {
            super(model);
            cancelReason(model.cancelReason);
            importTaskId(model.importTaskId);
        }

        public final String getCancelReason() {
            return cancelReason;
        }

        @Override
        public final Builder cancelReason(String cancelReason) {
            this.cancelReason = cancelReason;
            return this;
        }

        public final void setCancelReason(String cancelReason) {
            this.cancelReason = cancelReason;
        }

        public final String getImportTaskId() {
            return importTaskId;
        }

        @Override
        public final Builder importTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
            return this;
        }

        public final void setImportTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CancelImportTaskRequest build() {
            return new CancelImportTaskRequest(this);
        }
    }
}
