/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for AssignPrivateIpAddresses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AssignPrivateIpAddressesRequest extends EC2Request implements
        ToCopyableBuilder<AssignPrivateIpAddressesRequest.Builder, AssignPrivateIpAddressesRequest> {
    private final Boolean allowReassignment;

    private final String networkInterfaceId;

    private final List<String> privateIpAddresses;

    private final Integer secondaryPrivateIpAddressCount;

    private AssignPrivateIpAddressesRequest(BuilderImpl builder) {
        super(builder);
        this.allowReassignment = builder.allowReassignment;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.secondaryPrivateIpAddressCount = builder.secondaryPrivateIpAddressCount;
    }

    /**
     * <p>
     * Indicates whether to allow an IP address that is already assigned to another network interface or instance to be
     * reassigned to the specified network interface.
     * </p>
     * 
     * @return Indicates whether to allow an IP address that is already assigned to another network interface or
     *         instance to be reassigned to the specified network interface.
     */
    public Boolean allowReassignment() {
        return allowReassignment;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * One or more IP addresses to be assigned as a secondary private IP address to the network interface. You can't
     * specify this parameter when also specifying a number of secondary IP addresses.
     * </p>
     * <p>
     * If you don't specify an IP address, Amazon EC2 automatically selects an IP address within the subnet range.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more IP addresses to be assigned as a secondary private IP address to the network interface. You
     *         can't specify this parameter when also specifying a number of secondary IP addresses.</p>
     *         <p>
     *         If you don't specify an IP address, Amazon EC2 automatically selects an IP address within the subnet
     *         range.
     */
    public List<String> privateIpAddresses() {
        return privateIpAddresses;
    }

    /**
     * <p>
     * The number of secondary IP addresses to assign to the network interface. You can't specify this parameter when
     * also specifying private IP addresses.
     * </p>
     * 
     * @return The number of secondary IP addresses to assign to the network interface. You can't specify this parameter
     *         when also specifying private IP addresses.
     */
    public Integer secondaryPrivateIpAddressCount() {
        return secondaryPrivateIpAddressCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allowReassignment());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddresses());
        hashCode = 31 * hashCode + Objects.hashCode(secondaryPrivateIpAddressCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignPrivateIpAddressesRequest)) {
            return false;
        }
        AssignPrivateIpAddressesRequest other = (AssignPrivateIpAddressesRequest) obj;
        return Objects.equals(allowReassignment(), other.allowReassignment())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(privateIpAddresses(), other.privateIpAddresses())
                && Objects.equals(secondaryPrivateIpAddressCount(), other.secondaryPrivateIpAddressCount());
    }

    @Override
    public String toString() {
        return ToString.builder("AssignPrivateIpAddressesRequest").add("AllowReassignment", allowReassignment())
                .add("NetworkInterfaceId", networkInterfaceId()).add("PrivateIpAddresses", privateIpAddresses())
                .add("SecondaryPrivateIpAddressCount", secondaryPrivateIpAddressCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllowReassignment":
            return Optional.of(clazz.cast(allowReassignment()));
        case "NetworkInterfaceId":
            return Optional.of(clazz.cast(networkInterfaceId()));
        case "PrivateIpAddresses":
            return Optional.of(clazz.cast(privateIpAddresses()));
        case "SecondaryPrivateIpAddressCount":
            return Optional.of(clazz.cast(secondaryPrivateIpAddressCount()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, AssignPrivateIpAddressesRequest> {
        /**
         * <p>
         * Indicates whether to allow an IP address that is already assigned to another network interface or instance to
         * be reassigned to the specified network interface.
         * </p>
         * 
         * @param allowReassignment
         *        Indicates whether to allow an IP address that is already assigned to another network interface or
         *        instance to be reassigned to the specified network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowReassignment(Boolean allowReassignment);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * One or more IP addresses to be assigned as a secondary private IP address to the network interface. You can't
         * specify this parameter when also specifying a number of secondary IP addresses.
         * </p>
         * <p>
         * If you don't specify an IP address, Amazon EC2 automatically selects an IP address within the subnet range.
         * </p>
         * 
         * @param privateIpAddresses
         *        One or more IP addresses to be assigned as a secondary private IP address to the network interface.
         *        You can't specify this parameter when also specifying a number of secondary IP addresses.</p>
         *        <p>
         *        If you don't specify an IP address, Amazon EC2 automatically selects an IP address within the subnet
         *        range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(Collection<String> privateIpAddresses);

        /**
         * <p>
         * One or more IP addresses to be assigned as a secondary private IP address to the network interface. You can't
         * specify this parameter when also specifying a number of secondary IP addresses.
         * </p>
         * <p>
         * If you don't specify an IP address, Amazon EC2 automatically selects an IP address within the subnet range.
         * </p>
         * 
         * @param privateIpAddresses
         *        One or more IP addresses to be assigned as a secondary private IP address to the network interface.
         *        You can't specify this parameter when also specifying a number of secondary IP addresses.</p>
         *        <p>
         *        If you don't specify an IP address, Amazon EC2 automatically selects an IP address within the subnet
         *        range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(String... privateIpAddresses);

        /**
         * <p>
         * The number of secondary IP addresses to assign to the network interface. You can't specify this parameter
         * when also specifying private IP addresses.
         * </p>
         * 
         * @param secondaryPrivateIpAddressCount
         *        The number of secondary IP addresses to assign to the network interface. You can't specify this
         *        parameter when also specifying private IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private Boolean allowReassignment;

        private String networkInterfaceId;

        private List<String> privateIpAddresses;

        private Integer secondaryPrivateIpAddressCount;

        private BuilderImpl() {
        }

        private BuilderImpl(AssignPrivateIpAddressesRequest model) {
            super(model);
            allowReassignment(model.allowReassignment);
            networkInterfaceId(model.networkInterfaceId);
            privateIpAddresses(model.privateIpAddresses);
            secondaryPrivateIpAddressCount(model.secondaryPrivateIpAddressCount);
        }

        public final Boolean getAllowReassignment() {
            return allowReassignment;
        }

        @Override
        public final Builder allowReassignment(Boolean allowReassignment) {
            this.allowReassignment = allowReassignment;
            return this;
        }

        public final void setAllowReassignment(Boolean allowReassignment) {
            this.allowReassignment = allowReassignment;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final Collection<String> getPrivateIpAddresses() {
            return privateIpAddresses;
        }

        @Override
        public final Builder privateIpAddresses(Collection<String> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressStringListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(String... privateIpAddresses) {
            privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        public final void setPrivateIpAddresses(Collection<String> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressStringListCopier.copy(privateIpAddresses);
        }

        public final Integer getSecondaryPrivateIpAddressCount() {
            return secondaryPrivateIpAddressCount;
        }

        @Override
        public final Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
            return this;
        }

        public final void setSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AssignPrivateIpAddressesRequest build() {
            return new AssignPrivateIpAddressesRequest(this);
        }
    }
}
