/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for AllocateAddress.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AllocateAddressRequest extends EC2Request implements
        ToCopyableBuilder<AllocateAddressRequest.Builder, AllocateAddressRequest> {
    private final String domain;

    private final String address;

    private AllocateAddressRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
        this.address = builder.address;
    }

    /**
     * <p>
     * Set to <code>vpc</code> to allocate the address for use with instances in a VPC.
     * </p>
     * <p>
     * Default: The address is for use with instances in EC2-Classic.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domain} will
     * return {@link DomainType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainAsString}.
     * </p>
     * 
     * @return Set to <code>vpc</code> to allocate the address for use with instances in a VPC.</p>
     *         <p>
     *         Default: The address is for use with instances in EC2-Classic.
     * @see DomainType
     */
    public DomainType domain() {
        return DomainType.fromValue(domain);
    }

    /**
     * <p>
     * Set to <code>vpc</code> to allocate the address for use with instances in a VPC.
     * </p>
     * <p>
     * Default: The address is for use with instances in EC2-Classic.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #domain} will
     * return {@link DomainType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #domainAsString}.
     * </p>
     * 
     * @return Set to <code>vpc</code> to allocate the address for use with instances in a VPC.</p>
     *         <p>
     *         Default: The address is for use with instances in EC2-Classic.
     * @see DomainType
     */
    public String domainAsString() {
        return domain;
    }

    /**
     * <p>
     * [EC2-VPC] The Elastic IP address to recover.
     * </p>
     * 
     * @return [EC2-VPC] The Elastic IP address to recover.
     */
    public String address() {
        return address;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainAsString());
        hashCode = 31 * hashCode + Objects.hashCode(address());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocateAddressRequest)) {
            return false;
        }
        AllocateAddressRequest other = (AllocateAddressRequest) obj;
        return Objects.equals(domainAsString(), other.domainAsString()) && Objects.equals(address(), other.address());
    }

    @Override
    public String toString() {
        return ToString.builder("AllocateAddressRequest").add("Domain", domainAsString()).add("Address", address()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Domain":
            return Optional.of(clazz.cast(domainAsString()));
        case "Address":
            return Optional.of(clazz.cast(address()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, AllocateAddressRequest> {
        /**
         * <p>
         * Set to <code>vpc</code> to allocate the address for use with instances in a VPC.
         * </p>
         * <p>
         * Default: The address is for use with instances in EC2-Classic.
         * </p>
         * 
         * @param domain
         *        Set to <code>vpc</code> to allocate the address for use with instances in a VPC.</p>
         *        <p>
         *        Default: The address is for use with instances in EC2-Classic.
         * @see DomainType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainType
         */
        Builder domain(String domain);

        /**
         * <p>
         * Set to <code>vpc</code> to allocate the address for use with instances in a VPC.
         * </p>
         * <p>
         * Default: The address is for use with instances in EC2-Classic.
         * </p>
         * 
         * @param domain
         *        Set to <code>vpc</code> to allocate the address for use with instances in a VPC.</p>
         *        <p>
         *        Default: The address is for use with instances in EC2-Classic.
         * @see DomainType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DomainType
         */
        Builder domain(DomainType domain);

        /**
         * <p>
         * [EC2-VPC] The Elastic IP address to recover.
         * </p>
         * 
         * @param address
         *        [EC2-VPC] The Elastic IP address to recover.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(String address);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String domain;

        private String address;

        private BuilderImpl() {
        }

        private BuilderImpl(AllocateAddressRequest model) {
            super(model);
            domain(model.domain);
            address(model.address);
        }

        public final String getDomain() {
            return domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        public final Builder domain(DomainType domain) {
            this.domain(domain.toString());
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final String getAddress() {
            return address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AllocateAddressRequest build() {
            return new AllocateAddressRequest(this);
        }
    }
}
