/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an account attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AccountAttribute implements ToCopyableBuilder<AccountAttribute.Builder, AccountAttribute> {
    private final String attributeName;

    private final List<AccountAttributeValue> attributeValues;

    private AccountAttribute(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.attributeValues = builder.attributeValues;
    }

    /**
     * <p>
     * The name of the account attribute.
     * </p>
     * 
     * @return The name of the account attribute.
     */
    public String attributeName() {
        return attributeName;
    }

    /**
     * <p>
     * One or more values for the account attribute.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more values for the account attribute.
     */
    public List<AccountAttributeValue> attributeValues() {
        return attributeValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(attributeValues());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountAttribute)) {
            return false;
        }
        AccountAttribute other = (AccountAttribute) obj;
        return Objects.equals(attributeName(), other.attributeName())
                && Objects.equals(attributeValues(), other.attributeValues());
    }

    @Override
    public String toString() {
        return ToString.builder("AccountAttribute").add("AttributeName", attributeName())
                .add("AttributeValues", attributeValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeName":
            return Optional.of(clazz.cast(attributeName()));
        case "AttributeValues":
            return Optional.of(clazz.cast(attributeValues()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, AccountAttribute> {
        /**
         * <p>
         * The name of the account attribute.
         * </p>
         * 
         * @param attributeName
         *        The name of the account attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * One or more values for the account attribute.
         * </p>
         * 
         * @param attributeValues
         *        One or more values for the account attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeValues(Collection<AccountAttributeValue> attributeValues);

        /**
         * <p>
         * One or more values for the account attribute.
         * </p>
         * 
         * @param attributeValues
         *        One or more values for the account attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeValues(AccountAttributeValue... attributeValues);

        /**
         * <p>
         * One or more values for the account attribute.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AccountAttributeValue>.Builder} avoiding
         * the need to create one manually via {@link List<AccountAttributeValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AccountAttributeValue>.Builder#build()} is called
         * immediately and its result is passed to {@link #attributeValues(List<AccountAttributeValue>)}.
         * 
         * @param attributeValues
         *        a consumer that will call methods on {@link List<AccountAttributeValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeValues(List<AccountAttributeValue>)
         */
        Builder attributeValues(Consumer<AccountAttributeValue.Builder>... attributeValues);
    }

    static final class BuilderImpl implements Builder {
        private String attributeName;

        private List<AccountAttributeValue> attributeValues;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountAttribute model) {
            attributeName(model.attributeName);
            attributeValues(model.attributeValues);
        }

        public final String getAttributeName() {
            return attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final Collection<AccountAttributeValue.Builder> getAttributeValues() {
            return attributeValues != null ? attributeValues.stream().map(AccountAttributeValue::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributeValues(Collection<AccountAttributeValue> attributeValues) {
            this.attributeValues = AccountAttributeValueListCopier.copy(attributeValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeValues(AccountAttributeValue... attributeValues) {
            attributeValues(Arrays.asList(attributeValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeValues(Consumer<AccountAttributeValue.Builder>... attributeValues) {
            attributeValues(Stream.of(attributeValues).map(c -> AccountAttributeValue.builder().apply(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAttributeValues(Collection<AccountAttributeValue.BuilderImpl> attributeValues) {
            this.attributeValues = AccountAttributeValueListCopier.copyFromBuilder(attributeValues);
        }

        @Override
        public AccountAttribute build() {
            return new AccountAttribute(this);
        }
    }
}
