/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ebs.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartSnapshotResponse extends EbsResponse implements
        ToCopyableBuilder<StartSnapshotResponse.Builder, StartSnapshotResponse> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(StartSnapshotResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId").getter(getter(StartSnapshotResponse::snapshotId)).setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerId").getter(getter(StartSnapshotResponse::ownerId)).setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(StartSnapshotResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(StartSnapshotResponse::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Long> VOLUME_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("VolumeSize").getter(getter(StartSnapshotResponse::volumeSize)).setter(setter(Builder::volumeSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSize").build()).build();

    private static final SdkField<Integer> BLOCK_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BlockSize").getter(getter(StartSnapshotResponse::blockSize)).setter(setter(Builder::blockSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockSize").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(StartSnapshotResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PARENT_SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParentSnapshotId").getter(getter(StartSnapshotResponse::parentSnapshotId))
            .setter(setter(Builder::parentSnapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentSnapshotId").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyArn").getter(getter(StartSnapshotResponse::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            SNAPSHOT_ID_FIELD, OWNER_ID_FIELD, STATUS_FIELD, START_TIME_FIELD, VOLUME_SIZE_FIELD, BLOCK_SIZE_FIELD, TAGS_FIELD,
            PARENT_SNAPSHOT_ID_FIELD, KMS_KEY_ARN_FIELD));

    private final String description;

    private final String snapshotId;

    private final String ownerId;

    private final String status;

    private final Instant startTime;

    private final Long volumeSize;

    private final Integer blockSize;

    private final List<Tag> tags;

    private final String parentSnapshotId;

    private final String kmsKeyArn;

    private StartSnapshotResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.snapshotId = builder.snapshotId;
        this.ownerId = builder.ownerId;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.volumeSize = builder.volumeSize;
        this.blockSize = builder.blockSize;
        this.tags = builder.tags;
        this.parentSnapshotId = builder.parentSnapshotId;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    /**
     * <p>
     * The description of the snapshot.
     * </p>
     * 
     * @return The description of the snapshot.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the snapshot.
     * </p>
     * 
     * @return The ID of the snapshot.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the snapshot owner.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the snapshot owner.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The status of the snapshot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the snapshot.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The status of the snapshot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the snapshot.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The timestamp when the snapshot was created.
     * </p>
     * 
     * @return The timestamp when the snapshot was created.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The size of the volume, in GiB.
     * </p>
     * 
     * @return The size of the volume, in GiB.
     */
    public final Long volumeSize() {
        return volumeSize;
    }

    /**
     * <p>
     * The size of the blocks in the snapshot, in bytes.
     * </p>
     * 
     * @return The size of the blocks in the snapshot, in bytes.
     */
    public final Integer blockSize() {
        return blockSize;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags applied to the snapshot. You can specify up to 50 tags per snapshot. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html"> Tagging your Amazon EC2 resources</a>
     * in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags applied to the snapshot. You can specify up to 50 tags per snapshot. For more information, see
     *         <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html"> Tagging your Amazon EC2
     *         resources</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The ID of the parent snapshot.
     * </p>
     * 
     * @return The ID of the parent snapshot.
     */
    public final String parentSnapshotId() {
        return parentSnapshotId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Key Management Service (KMS) key used to encrypt the snapshot.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Key Management Service (KMS) key used to encrypt the snapshot.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSize());
        hashCode = 31 * hashCode + Objects.hashCode(blockSize());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(parentSnapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSnapshotResponse)) {
            return false;
        }
        StartSnapshotResponse other = (StartSnapshotResponse) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(snapshotId(), other.snapshotId())
                && Objects.equals(ownerId(), other.ownerId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(volumeSize(), other.volumeSize())
                && Objects.equals(blockSize(), other.blockSize()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(parentSnapshotId(), other.parentSnapshotId())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartSnapshotResponse").add("Description", description()).add("SnapshotId", snapshotId())
                .add("OwnerId", ownerId()).add("Status", statusAsString()).add("StartTime", startTime())
                .add("VolumeSize", volumeSize()).add("BlockSize", blockSize()).add("Tags", hasTags() ? tags() : null)
                .add("ParentSnapshotId", parentSnapshotId())
                .add("KmsKeyArn", kmsKeyArn() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "VolumeSize":
            return Optional.ofNullable(clazz.cast(volumeSize()));
        case "BlockSize":
            return Optional.ofNullable(clazz.cast(blockSize()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ParentSnapshotId":
            return Optional.ofNullable(clazz.cast(parentSnapshotId()));
        case "KmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartSnapshotResponse, T> g) {
        return obj -> g.apply((StartSnapshotResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EbsResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartSnapshotResponse> {
        /**
         * <p>
         * The description of the snapshot.
         * </p>
         * 
         * @param description
         *        The description of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the snapshot.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The Amazon Web Services account ID of the snapshot owner.
         * </p>
         * 
         * @param ownerId
         *        The Amazon Web Services account ID of the snapshot owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The status of the snapshot.
         * </p>
         * 
         * @param status
         *        The status of the snapshot.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the snapshot.
         * </p>
         * 
         * @param status
         *        The status of the snapshot.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * The timestamp when the snapshot was created.
         * </p>
         * 
         * @param startTime
         *        The timestamp when the snapshot was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The size of the volume, in GiB.
         * </p>
         * 
         * @param volumeSize
         *        The size of the volume, in GiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSize(Long volumeSize);

        /**
         * <p>
         * The size of the blocks in the snapshot, in bytes.
         * </p>
         * 
         * @param blockSize
         *        The size of the blocks in the snapshot, in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockSize(Integer blockSize);

        /**
         * <p>
         * The tags applied to the snapshot. You can specify up to 50 tags per snapshot. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html"> Tagging your Amazon EC2
         * resources</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param tags
         *        The tags applied to the snapshot. You can specify up to 50 tags per snapshot. For more information,
         *        see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html"> Tagging your Amazon
         *        EC2 resources</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags applied to the snapshot. You can specify up to 50 tags per snapshot. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html"> Tagging your Amazon EC2
         * resources</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param tags
         *        The tags applied to the snapshot. You can specify up to 50 tags per snapshot. For more information,
         *        see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html"> Tagging your Amazon
         *        EC2 resources</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags applied to the snapshot. You can specify up to 50 tags per snapshot. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html"> Tagging your Amazon EC2
         * resources</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ebs.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ebs.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ebs.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ebs.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The ID of the parent snapshot.
         * </p>
         * 
         * @param parentSnapshotId
         *        The ID of the parent snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentSnapshotId(String parentSnapshotId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Key Management Service (KMS) key used to encrypt the snapshot.
         * </p>
         * 
         * @param kmsKeyArn
         *        The Amazon Resource Name (ARN) of the Key Management Service (KMS) key used to encrypt the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);
    }

    static final class BuilderImpl extends EbsResponse.BuilderImpl implements Builder {
        private String description;

        private String snapshotId;

        private String ownerId;

        private String status;

        private Instant startTime;

        private Long volumeSize;

        private Integer blockSize;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String parentSnapshotId;

        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSnapshotResponse model) {
            super(model);
            description(model.description);
            snapshotId(model.snapshotId);
            ownerId(model.ownerId);
            status(model.status);
            startTime(model.startTime);
            volumeSize(model.volumeSize);
            blockSize(model.blockSize);
            tags(model.tags);
            parentSnapshotId(model.parentSnapshotId);
            kmsKeyArn(model.kmsKeyArn);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Long getVolumeSize() {
            return volumeSize;
        }

        public final void setVolumeSize(Long volumeSize) {
            this.volumeSize = volumeSize;
        }

        @Override
        public final Builder volumeSize(Long volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public final Integer getBlockSize() {
            return blockSize;
        }

        public final void setBlockSize(Integer blockSize) {
            this.blockSize = blockSize;
        }

        @Override
        public final Builder blockSize(Integer blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getParentSnapshotId() {
            return parentSnapshotId;
        }

        public final void setParentSnapshotId(String parentSnapshotId) {
            this.parentSnapshotId = parentSnapshotId;
        }

        @Override
        public final Builder parentSnapshotId(String parentSnapshotId) {
            this.parentSnapshotId = parentSnapshotId;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        @Override
        public StartSnapshotResponse build() {
            return new StartSnapshotResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
