/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreTableFromBackupRequest
extends DynamoDbRequest
implements ToCopyableBuilder<Builder, RestoreTableFromBackupRequest> {
    private static final SdkField<String> TARGET_TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RestoreTableFromBackupRequest.getter(RestoreTableFromBackupRequest::targetTableName)).setter(RestoreTableFromBackupRequest.setter(Builder::targetTableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTableName").build()}).build();
    private static final SdkField<String> BACKUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RestoreTableFromBackupRequest.getter(RestoreTableFromBackupRequest::backupArn)).setter(RestoreTableFromBackupRequest.setter(Builder::backupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_TABLE_NAME_FIELD, BACKUP_ARN_FIELD));
    private final String targetTableName;
    private final String backupArn;

    private RestoreTableFromBackupRequest(BuilderImpl builder) {
        super(builder);
        this.targetTableName = builder.targetTableName;
        this.backupArn = builder.backupArn;
    }

    public String targetTableName() {
        return this.targetTableName;
    }

    public String backupArn() {
        return this.backupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreTableFromBackupRequest)) {
            return false;
        }
        RestoreTableFromBackupRequest other = (RestoreTableFromBackupRequest)((Object)obj);
        return Objects.equals(this.targetTableName(), other.targetTableName()) && Objects.equals(this.backupArn(), other.backupArn());
    }

    public String toString() {
        return ToString.builder((String)"RestoreTableFromBackupRequest").add("TargetTableName", (Object)this.targetTableName()).add("BackupArn", (Object)this.backupArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetTableName": {
                return Optional.ofNullable(clazz.cast(this.targetTableName()));
            }
            case "BackupArn": {
                return Optional.ofNullable(clazz.cast(this.backupArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreTableFromBackupRequest, T> g) {
        return obj -> g.apply((RestoreTableFromBackupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbRequest.BuilderImpl
    implements Builder {
        private String targetTableName;
        private String backupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreTableFromBackupRequest model) {
            super(model);
            this.targetTableName(model.targetTableName);
            this.backupArn(model.backupArn);
        }

        public final String getTargetTableName() {
            return this.targetTableName;
        }

        @Override
        public final Builder targetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
            return this;
        }

        public final void setTargetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
        }

        public final String getBackupArn() {
            return this.backupArn;
        }

        @Override
        public final Builder backupArn(String backupArn) {
            this.backupArn = backupArn;
            return this;
        }

        public final void setBackupArn(String backupArn) {
            this.backupArn = backupArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreTableFromBackupRequest build() {
            return new RestoreTableFromBackupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DynamoDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RestoreTableFromBackupRequest> {
        public Builder targetTableName(String var1);

        public Builder backupArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

