/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.ImportStatus;
import software.amazon.awssdk.services.dynamodb.model.InputFormat;
import software.amazon.awssdk.services.dynamodb.model.S3BucketSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImportSummary> {
    private static final SdkField<String> IMPORT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImportArn").getter(ImportSummary.getter(ImportSummary::importArn)).setter(ImportSummary.setter(Builder::importArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportArn").build()}).build();
    private static final SdkField<String> IMPORT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImportStatus").getter(ImportSummary.getter(ImportSummary::importStatusAsString)).setter(ImportSummary.setter(Builder::importStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportStatus").build()}).build();
    private static final SdkField<String> TABLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableArn").getter(ImportSummary.getter(ImportSummary::tableArn)).setter(ImportSummary.setter(Builder::tableArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableArn").build()}).build();
    private static final SdkField<S3BucketSource> S3_BUCKET_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3BucketSource").getter(ImportSummary.getter(ImportSummary::s3BucketSource)).setter(ImportSummary.setter(Builder::s3BucketSource)).constructor(S3BucketSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketSource").build()}).build();
    private static final SdkField<String> CLOUD_WATCH_LOG_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloudWatchLogGroupArn").getter(ImportSummary.getter(ImportSummary::cloudWatchLogGroupArn)).setter(ImportSummary.setter(Builder::cloudWatchLogGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogGroupArn").build()}).build();
    private static final SdkField<String> INPUT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputFormat").getter(ImportSummary.getter(ImportSummary::inputFormatAsString)).setter(ImportSummary.setter(Builder::inputFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputFormat").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(ImportSummary.getter(ImportSummary::startTime)).setter(ImportSummary.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(ImportSummary.getter(ImportSummary::endTime)).setter(ImportSummary.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_ARN_FIELD, IMPORT_STATUS_FIELD, TABLE_ARN_FIELD, S3_BUCKET_SOURCE_FIELD, CLOUD_WATCH_LOG_GROUP_ARN_FIELD, INPUT_FORMAT_FIELD, START_TIME_FIELD, END_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImportSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String importArn;
    private final String importStatus;
    private final String tableArn;
    private final S3BucketSource s3BucketSource;
    private final String cloudWatchLogGroupArn;
    private final String inputFormat;
    private final Instant startTime;
    private final Instant endTime;

    private ImportSummary(BuilderImpl builder) {
        this.importArn = builder.importArn;
        this.importStatus = builder.importStatus;
        this.tableArn = builder.tableArn;
        this.s3BucketSource = builder.s3BucketSource;
        this.cloudWatchLogGroupArn = builder.cloudWatchLogGroupArn;
        this.inputFormat = builder.inputFormat;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    public final String importArn() {
        return this.importArn;
    }

    public final ImportStatus importStatus() {
        return ImportStatus.fromValue(this.importStatus);
    }

    public final String importStatusAsString() {
        return this.importStatus;
    }

    public final String tableArn() {
        return this.tableArn;
    }

    public final S3BucketSource s3BucketSource() {
        return this.s3BucketSource;
    }

    public final String cloudWatchLogGroupArn() {
        return this.cloudWatchLogGroupArn;
    }

    public final InputFormat inputFormat() {
        return InputFormat.fromValue(this.inputFormat);
    }

    public final String inputFormatAsString() {
        return this.inputFormat;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.importArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.importStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportSummary)) {
            return false;
        }
        ImportSummary other = (ImportSummary)obj;
        return Objects.equals(this.importArn(), other.importArn()) && Objects.equals(this.importStatusAsString(), other.importStatusAsString()) && Objects.equals(this.tableArn(), other.tableArn()) && Objects.equals(this.s3BucketSource(), other.s3BucketSource()) && Objects.equals(this.cloudWatchLogGroupArn(), other.cloudWatchLogGroupArn()) && Objects.equals(this.inputFormatAsString(), other.inputFormatAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime());
    }

    public final String toString() {
        return ToString.builder((String)"ImportSummary").add("ImportArn", (Object)this.importArn()).add("ImportStatus", (Object)this.importStatusAsString()).add("TableArn", (Object)this.tableArn()).add("S3BucketSource", (Object)this.s3BucketSource()).add("CloudWatchLogGroupArn", (Object)this.cloudWatchLogGroupArn()).add("InputFormat", (Object)this.inputFormatAsString()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImportArn": {
                return Optional.ofNullable(clazz.cast(this.importArn()));
            }
            case "ImportStatus": {
                return Optional.ofNullable(clazz.cast(this.importStatusAsString()));
            }
            case "TableArn": {
                return Optional.ofNullable(clazz.cast(this.tableArn()));
            }
            case "S3BucketSource": {
                return Optional.ofNullable(clazz.cast(this.s3BucketSource()));
            }
            case "CloudWatchLogGroupArn": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogGroupArn()));
            }
            case "InputFormat": {
                return Optional.ofNullable(clazz.cast(this.inputFormatAsString()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ImportArn", IMPORT_ARN_FIELD);
        map.put("ImportStatus", IMPORT_STATUS_FIELD);
        map.put("TableArn", TABLE_ARN_FIELD);
        map.put("S3BucketSource", S3_BUCKET_SOURCE_FIELD);
        map.put("CloudWatchLogGroupArn", CLOUD_WATCH_LOG_GROUP_ARN_FIELD);
        map.put("InputFormat", INPUT_FORMAT_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportSummary, T> g) {
        return obj -> g.apply((ImportSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String importArn;
        private String importStatus;
        private String tableArn;
        private S3BucketSource s3BucketSource;
        private String cloudWatchLogGroupArn;
        private String inputFormat;
        private Instant startTime;
        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportSummary model) {
            this.importArn(model.importArn);
            this.importStatus(model.importStatus);
            this.tableArn(model.tableArn);
            this.s3BucketSource(model.s3BucketSource);
            this.cloudWatchLogGroupArn(model.cloudWatchLogGroupArn);
            this.inputFormat(model.inputFormat);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
        }

        public final String getImportArn() {
            return this.importArn;
        }

        public final void setImportArn(String importArn) {
            this.importArn = importArn;
        }

        @Override
        public final Builder importArn(String importArn) {
            this.importArn = importArn;
            return this;
        }

        public final String getImportStatus() {
            return this.importStatus;
        }

        public final void setImportStatus(String importStatus) {
            this.importStatus = importStatus;
        }

        @Override
        public final Builder importStatus(String importStatus) {
            this.importStatus = importStatus;
            return this;
        }

        @Override
        public final Builder importStatus(ImportStatus importStatus) {
            this.importStatus(importStatus == null ? null : importStatus.toString());
            return this;
        }

        public final String getTableArn() {
            return this.tableArn;
        }

        public final void setTableArn(String tableArn) {
            this.tableArn = tableArn;
        }

        @Override
        public final Builder tableArn(String tableArn) {
            this.tableArn = tableArn;
            return this;
        }

        public final S3BucketSource.Builder getS3BucketSource() {
            return this.s3BucketSource != null ? this.s3BucketSource.toBuilder() : null;
        }

        public final void setS3BucketSource(S3BucketSource.BuilderImpl s3BucketSource) {
            this.s3BucketSource = s3BucketSource != null ? s3BucketSource.build() : null;
        }

        @Override
        public final Builder s3BucketSource(S3BucketSource s3BucketSource) {
            this.s3BucketSource = s3BucketSource;
            return this;
        }

        public final String getCloudWatchLogGroupArn() {
            return this.cloudWatchLogGroupArn;
        }

        public final void setCloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
        }

        @Override
        public final Builder cloudWatchLogGroupArn(String cloudWatchLogGroupArn) {
            this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
            return this;
        }

        public final String getInputFormat() {
            return this.inputFormat;
        }

        public final void setInputFormat(String inputFormat) {
            this.inputFormat = inputFormat;
        }

        @Override
        public final Builder inputFormat(String inputFormat) {
            this.inputFormat = inputFormat;
            return this;
        }

        @Override
        public final Builder inputFormat(InputFormat inputFormat) {
            this.inputFormat(inputFormat == null ? null : inputFormat.toString());
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public ImportSummary build() {
            return new ImportSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImportSummary> {
        public Builder importArn(String var1);

        public Builder importStatus(String var1);

        public Builder importStatus(ImportStatus var1);

        public Builder tableArn(String var1);

        public Builder s3BucketSource(S3BucketSource var1);

        default public Builder s3BucketSource(Consumer<S3BucketSource.Builder> s3BucketSource) {
            return this.s3BucketSource((S3BucketSource)((S3BucketSource.Builder)S3BucketSource.builder().applyMutation(s3BucketSource)).build());
        }

        public Builder cloudWatchLogGroupArn(String var1);

        public Builder inputFormat(String var1);

        public Builder inputFormat(InputFormat var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);
    }
}

