/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbRequest;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItem;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransactGetItemsRequest
extends DynamoDbRequest
implements ToCopyableBuilder<Builder, TransactGetItemsRequest> {
    private static final SdkField<List<TransactGetItem>> TRANSACT_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TransactItems").getter(TransactGetItemsRequest.getter(TransactGetItemsRequest::transactItems)).setter(TransactGetItemsRequest.setter(Builder::transactItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransactGetItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RETURN_CONSUMED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReturnConsumedCapacity").getter(TransactGetItemsRequest.getter(TransactGetItemsRequest::returnConsumedCapacityAsString)).setter(TransactGetItemsRequest.setter(Builder::returnConsumedCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnConsumedCapacity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSACT_ITEMS_FIELD, RETURN_CONSUMED_CAPACITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TransactGetItemsRequest.memberNameToFieldInitializer();
    private final List<TransactGetItem> transactItems;
    private final String returnConsumedCapacity;

    private TransactGetItemsRequest(BuilderImpl builder) {
        super(builder);
        this.transactItems = builder.transactItems;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
    }

    public final boolean hasTransactItems() {
        return this.transactItems != null && !(this.transactItems instanceof SdkAutoConstructList);
    }

    public final List<TransactGetItem> transactItems() {
        return this.transactItems;
    }

    public final ReturnConsumedCapacity returnConsumedCapacity() {
        return ReturnConsumedCapacity.fromValue(this.returnConsumedCapacity);
    }

    public final String returnConsumedCapacityAsString() {
        return this.returnConsumedCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTransactItems() ? this.transactItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.returnConsumedCapacityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransactGetItemsRequest)) {
            return false;
        }
        TransactGetItemsRequest other = (TransactGetItemsRequest)((Object)obj);
        return this.hasTransactItems() == other.hasTransactItems() && Objects.equals(this.transactItems(), other.transactItems()) && Objects.equals(this.returnConsumedCapacityAsString(), other.returnConsumedCapacityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TransactGetItemsRequest").add("TransactItems", this.hasTransactItems() ? this.transactItems() : null).add("ReturnConsumedCapacity", (Object)this.returnConsumedCapacityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransactItems": {
                return Optional.ofNullable(clazz.cast(this.transactItems()));
            }
            case "ReturnConsumedCapacity": {
                return Optional.ofNullable(clazz.cast(this.returnConsumedCapacityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TransactItems", TRANSACT_ITEMS_FIELD);
        map.put("ReturnConsumedCapacity", RETURN_CONSUMED_CAPACITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransactGetItemsRequest, T> g) {
        return obj -> g.apply((TransactGetItemsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbRequest.BuilderImpl
    implements Builder {
        private List<TransactGetItem> transactItems = DefaultSdkAutoConstructList.getInstance();
        private String returnConsumedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(TransactGetItemsRequest model) {
            super(model);
            this.transactItems(model.transactItems);
            this.returnConsumedCapacity(model.returnConsumedCapacity);
        }

        public final List<TransactGetItem.Builder> getTransactItems() {
            List<TransactGetItem.Builder> result = TransactGetItemListCopier.copyToBuilder(this.transactItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransactItems(Collection<TransactGetItem.BuilderImpl> transactItems) {
            this.transactItems = TransactGetItemListCopier.copyFromBuilder(transactItems);
        }

        @Override
        public final Builder transactItems(Collection<TransactGetItem> transactItems) {
            this.transactItems = TransactGetItemListCopier.copy(transactItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transactItems(TransactGetItem ... transactItems) {
            this.transactItems(Arrays.asList(transactItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transactItems(Consumer<TransactGetItem.Builder> ... transactItems) {
            this.transactItems(Stream.of(transactItems).map(c -> (TransactGetItem)((TransactGetItem.Builder)TransactGetItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getReturnConsumedCapacity() {
            return this.returnConsumedCapacity;
        }

        public final void setReturnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
        }

        @Override
        public final Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        @Override
        public final Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity == null ? null : returnConsumedCapacity.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TransactGetItemsRequest build() {
            return new TransactGetItemsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DynamoDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TransactGetItemsRequest> {
        public Builder transactItems(Collection<TransactGetItem> var1);

        public Builder transactItems(TransactGetItem ... var1);

        public Builder transactItems(Consumer<TransactGetItem.Builder> ... var1);

        public Builder returnConsumedCapacity(String var1);

        public Builder returnConsumedCapacity(ReturnConsumedCapacity var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

