/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a failure a contributor insights operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailureException implements SdkPojo, Serializable,
        ToCopyableBuilder<FailureException.Builder, FailureException> {
    private static final SdkField<String> EXCEPTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExceptionName").getter(getter(FailureException::exceptionName)).setter(setter(Builder::exceptionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExceptionName").build()).build();

    private static final SdkField<String> EXCEPTION_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExceptionDescription").getter(getter(FailureException::exceptionDescription))
            .setter(setter(Builder::exceptionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExceptionDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCEPTION_NAME_FIELD,
            EXCEPTION_DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String exceptionName;

    private final String exceptionDescription;

    private FailureException(BuilderImpl builder) {
        this.exceptionName = builder.exceptionName;
        this.exceptionDescription = builder.exceptionDescription;
    }

    /**
     * <p>
     * Exception name.
     * </p>
     * 
     * @return Exception name.
     */
    public final String exceptionName() {
        return exceptionName;
    }

    /**
     * <p>
     * Description of the failure.
     * </p>
     * 
     * @return Description of the failure.
     */
    public final String exceptionDescription() {
        return exceptionDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(exceptionName());
        hashCode = 31 * hashCode + Objects.hashCode(exceptionDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailureException)) {
            return false;
        }
        FailureException other = (FailureException) obj;
        return Objects.equals(exceptionName(), other.exceptionName())
                && Objects.equals(exceptionDescription(), other.exceptionDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FailureException").add("ExceptionName", exceptionName())
                .add("ExceptionDescription", exceptionDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExceptionName":
            return Optional.ofNullable(clazz.cast(exceptionName()));
        case "ExceptionDescription":
            return Optional.ofNullable(clazz.cast(exceptionDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FailureException, T> g) {
        return obj -> g.apply((FailureException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailureException> {
        /**
         * <p>
         * Exception name.
         * </p>
         * 
         * @param exceptionName
         *        Exception name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exceptionName(String exceptionName);

        /**
         * <p>
         * Description of the failure.
         * </p>
         * 
         * @param exceptionDescription
         *        Description of the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exceptionDescription(String exceptionDescription);
    }

    static final class BuilderImpl implements Builder {
        private String exceptionName;

        private String exceptionDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(FailureException model) {
            exceptionName(model.exceptionName);
            exceptionDescription(model.exceptionDescription);
        }

        public final String getExceptionName() {
            return exceptionName;
        }

        public final void setExceptionName(String exceptionName) {
            this.exceptionName = exceptionName;
        }

        @Override
        public final Builder exceptionName(String exceptionName) {
            this.exceptionName = exceptionName;
            return this;
        }

        public final String getExceptionDescription() {
            return exceptionDescription;
        }

        public final void setExceptionDescription(String exceptionDescription) {
            this.exceptionDescription = exceptionDescription;
        }

        @Override
        public final Builder exceptionDescription(String exceptionDescription) {
            this.exceptionDescription = exceptionDescription;
            return this;
        }

        @Override
        public FailureException build() {
            return new FailureException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
