/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.ListExportsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListExportsResponse;

public class ListExportsIterable
implements SdkIterable<ListExportsResponse> {
    private final DynamoDbClient client;
    private final ListExportsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListExportsIterable(DynamoDbClient client, ListExportsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListExportsResponseFetcher();
    }

    public Iterator<ListExportsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListExportsResponseFetcher
    implements SyncPageFetcher<ListExportsResponse> {
        private ListExportsResponseFetcher() {
        }

        public boolean hasNextPage(ListExportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListExportsResponse nextPage(ListExportsResponse previousPage) {
            if (previousPage == null) {
                return ListExportsIterable.this.client.listExports(ListExportsIterable.this.firstRequest);
            }
            return ListExportsIterable.this.client.listExports((ListExportsRequest)((Object)ListExportsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

