/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteTransactionResponse extends DynamoDbResponse implements
        ToCopyableBuilder<ExecuteTransactionResponse.Builder, ExecuteTransactionResponse> {
    private static final SdkField<List<ItemResponse>> RESPONSES_FIELD = SdkField
            .<List<ItemResponse>> builder(MarshallingType.LIST)
            .memberName("Responses")
            .getter(getter(ExecuteTransactionResponse::responses))
            .setter(setter(Builder::responses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Responses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ItemResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(ItemResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESPONSES_FIELD));

    private final List<ItemResponse> responses;

    private ExecuteTransactionResponse(BuilderImpl builder) {
        super(builder);
        this.responses = builder.responses;
    }

    /**
     * For responses, this returns true if the service returned a value for the Responses property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResponses() {
        return responses != null && !(responses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The response to a PartiQL transaction.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResponses} method.
     * </p>
     * 
     * @return The response to a PartiQL transaction.
     */
    public final List<ItemResponse> responses() {
        return responses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResponses() ? responses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteTransactionResponse)) {
            return false;
        }
        ExecuteTransactionResponse other = (ExecuteTransactionResponse) obj;
        return hasResponses() == other.hasResponses() && Objects.equals(responses(), other.responses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecuteTransactionResponse").add("Responses", hasResponses() ? responses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Responses":
            return Optional.ofNullable(clazz.cast(responses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteTransactionResponse, T> g) {
        return obj -> g.apply((ExecuteTransactionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbResponse.Builder, SdkPojo, CopyableBuilder<Builder, ExecuteTransactionResponse> {
        /**
         * <p>
         * The response to a PartiQL transaction.
         * </p>
         * 
         * @param responses
         *        The response to a PartiQL transaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responses(Collection<ItemResponse> responses);

        /**
         * <p>
         * The response to a PartiQL transaction.
         * </p>
         * 
         * @param responses
         *        The response to a PartiQL transaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responses(ItemResponse... responses);

        /**
         * <p>
         * The response to a PartiQL transaction.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ItemResponse>.Builder} avoiding the need to
         * create one manually via {@link List<ItemResponse>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ItemResponse>.Builder#build()} is called immediately and its
         * result is passed to {@link #responses(List<ItemResponse>)}.
         * 
         * @param responses
         *        a consumer that will call methods on {@link List<ItemResponse>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #responses(List<ItemResponse>)
         */
        Builder responses(Consumer<ItemResponse.Builder>... responses);
    }

    static final class BuilderImpl extends DynamoDbResponse.BuilderImpl implements Builder {
        private List<ItemResponse> responses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteTransactionResponse model) {
            super(model);
            responses(model.responses);
        }

        public final List<ItemResponse.Builder> getResponses() {
            List<ItemResponse.Builder> result = ItemResponseListCopier.copyToBuilder(this.responses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResponses(Collection<ItemResponse.BuilderImpl> responses) {
            this.responses = ItemResponseListCopier.copyFromBuilder(responses);
        }

        @Override
        @Transient
        public final Builder responses(Collection<ItemResponse> responses) {
            this.responses = ItemResponseListCopier.copy(responses);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder responses(ItemResponse... responses) {
            responses(Arrays.asList(responses));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder responses(Consumer<ItemResponse.Builder>... responses) {
            responses(Stream.of(responses).map(c -> ItemResponse.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ExecuteTransactionResponse build() {
            return new ExecuteTransactionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
