/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents one of the following:
 * </p>
 * <ul>
 * <li>
 * <p>
 * A new replica to be added to an existing regional table or global table. This request invokes the
 * <code>CreateTableReplica</code> action in the destination Region.
 * </p>
 * </li>
 * <li>
 * <p>
 * New parameters for an existing replica. This request invokes the <code>UpdateTable</code> action in the destination
 * Region.
 * </p>
 * </li>
 * <li>
 * <p>
 * An existing replica to be deleted. The request invokes the <code>DeleteTableReplica</code> action in the destination
 * Region, deleting the replica and all if its items in the destination Region.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationGroupUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicationGroupUpdate.Builder, ReplicationGroupUpdate> {
    private static final SdkField<CreateReplicationGroupMemberAction> CREATE_FIELD = SdkField
            .<CreateReplicationGroupMemberAction> builder(MarshallingType.SDK_POJO).memberName("Create")
            .getter(getter(ReplicationGroupUpdate::create)).setter(setter(Builder::create))
            .constructor(CreateReplicationGroupMemberAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Create").build()).build();

    private static final SdkField<UpdateReplicationGroupMemberAction> UPDATE_FIELD = SdkField
            .<UpdateReplicationGroupMemberAction> builder(MarshallingType.SDK_POJO).memberName("Update")
            .getter(getter(ReplicationGroupUpdate::update)).setter(setter(Builder::update))
            .constructor(UpdateReplicationGroupMemberAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Update").build()).build();

    private static final SdkField<DeleteReplicationGroupMemberAction> DELETE_FIELD = SdkField
            .<DeleteReplicationGroupMemberAction> builder(MarshallingType.SDK_POJO).memberName("Delete")
            .getter(getter(ReplicationGroupUpdate::delete)).setter(setter(Builder::delete))
            .constructor(DeleteReplicationGroupMemberAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Delete").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_FIELD, UPDATE_FIELD,
            DELETE_FIELD));

    private static final long serialVersionUID = 1L;

    private final CreateReplicationGroupMemberAction create;

    private final UpdateReplicationGroupMemberAction update;

    private final DeleteReplicationGroupMemberAction delete;

    private ReplicationGroupUpdate(BuilderImpl builder) {
        this.create = builder.create;
        this.update = builder.update;
        this.delete = builder.delete;
    }

    /**
     * <p>
     * The parameters required for creating a replica for the table.
     * </p>
     * 
     * @return The parameters required for creating a replica for the table.
     */
    public final CreateReplicationGroupMemberAction create() {
        return create;
    }

    /**
     * <p>
     * The parameters required for updating a replica for the table.
     * </p>
     * 
     * @return The parameters required for updating a replica for the table.
     */
    public final UpdateReplicationGroupMemberAction update() {
        return update;
    }

    /**
     * <p>
     * The parameters required for deleting a replica for the table.
     * </p>
     * 
     * @return The parameters required for deleting a replica for the table.
     */
    public final DeleteReplicationGroupMemberAction delete() {
        return delete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(create());
        hashCode = 31 * hashCode + Objects.hashCode(update());
        hashCode = 31 * hashCode + Objects.hashCode(delete());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationGroupUpdate)) {
            return false;
        }
        ReplicationGroupUpdate other = (ReplicationGroupUpdate) obj;
        return Objects.equals(create(), other.create()) && Objects.equals(update(), other.update())
                && Objects.equals(delete(), other.delete());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicationGroupUpdate").add("Create", create()).add("Update", update()).add("Delete", delete())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Create":
            return Optional.ofNullable(clazz.cast(create()));
        case "Update":
            return Optional.ofNullable(clazz.cast(update()));
        case "Delete":
            return Optional.ofNullable(clazz.cast(delete()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationGroupUpdate, T> g) {
        return obj -> g.apply((ReplicationGroupUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationGroupUpdate> {
        /**
         * <p>
         * The parameters required for creating a replica for the table.
         * </p>
         * 
         * @param create
         *        The parameters required for creating a replica for the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder create(CreateReplicationGroupMemberAction create);

        /**
         * <p>
         * The parameters required for creating a replica for the table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CreateReplicationGroupMemberAction.Builder} avoiding the need to create one manually via
         * {@link CreateReplicationGroupMemberAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreateReplicationGroupMemberAction.Builder#build()} is called
         * immediately and its result is passed to {@link #create(CreateReplicationGroupMemberAction)}.
         * 
         * @param create
         *        a consumer that will call methods on {@link CreateReplicationGroupMemberAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #create(CreateReplicationGroupMemberAction)
         */
        default Builder create(Consumer<CreateReplicationGroupMemberAction.Builder> create) {
            return create(CreateReplicationGroupMemberAction.builder().applyMutation(create).build());
        }

        /**
         * <p>
         * The parameters required for updating a replica for the table.
         * </p>
         * 
         * @param update
         *        The parameters required for updating a replica for the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder update(UpdateReplicationGroupMemberAction update);

        /**
         * <p>
         * The parameters required for updating a replica for the table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdateReplicationGroupMemberAction.Builder} avoiding the need to create one manually via
         * {@link UpdateReplicationGroupMemberAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link UpdateReplicationGroupMemberAction.Builder#build()} is called
         * immediately and its result is passed to {@link #update(UpdateReplicationGroupMemberAction)}.
         * 
         * @param update
         *        a consumer that will call methods on {@link UpdateReplicationGroupMemberAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #update(UpdateReplicationGroupMemberAction)
         */
        default Builder update(Consumer<UpdateReplicationGroupMemberAction.Builder> update) {
            return update(UpdateReplicationGroupMemberAction.builder().applyMutation(update).build());
        }

        /**
         * <p>
         * The parameters required for deleting a replica for the table.
         * </p>
         * 
         * @param delete
         *        The parameters required for deleting a replica for the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delete(DeleteReplicationGroupMemberAction delete);

        /**
         * <p>
         * The parameters required for deleting a replica for the table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DeleteReplicationGroupMemberAction.Builder} avoiding the need to create one manually via
         * {@link DeleteReplicationGroupMemberAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeleteReplicationGroupMemberAction.Builder#build()} is called
         * immediately and its result is passed to {@link #delete(DeleteReplicationGroupMemberAction)}.
         * 
         * @param delete
         *        a consumer that will call methods on {@link DeleteReplicationGroupMemberAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #delete(DeleteReplicationGroupMemberAction)
         */
        default Builder delete(Consumer<DeleteReplicationGroupMemberAction.Builder> delete) {
            return delete(DeleteReplicationGroupMemberAction.builder().applyMutation(delete).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CreateReplicationGroupMemberAction create;

        private UpdateReplicationGroupMemberAction update;

        private DeleteReplicationGroupMemberAction delete;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationGroupUpdate model) {
            create(model.create);
            update(model.update);
            delete(model.delete);
        }

        public final CreateReplicationGroupMemberAction.Builder getCreate() {
            return create != null ? create.toBuilder() : null;
        }

        public final void setCreate(CreateReplicationGroupMemberAction.BuilderImpl create) {
            this.create = create != null ? create.build() : null;
        }

        @Override
        public final Builder create(CreateReplicationGroupMemberAction create) {
            this.create = create;
            return this;
        }

        public final UpdateReplicationGroupMemberAction.Builder getUpdate() {
            return update != null ? update.toBuilder() : null;
        }

        public final void setUpdate(UpdateReplicationGroupMemberAction.BuilderImpl update) {
            this.update = update != null ? update.build() : null;
        }

        @Override
        public final Builder update(UpdateReplicationGroupMemberAction update) {
            this.update = update;
            return this;
        }

        public final DeleteReplicationGroupMemberAction.Builder getDelete() {
            return delete != null ? delete.toBuilder() : null;
        }

        public final void setDelete(DeleteReplicationGroupMemberAction.BuilderImpl delete) {
            this.delete = delete != null ? delete.build() : null;
        }

        @Override
        public final Builder delete(DeleteReplicationGroupMemberAction delete) {
            this.delete = delete;
            return this;
        }

        @Override
        public ReplicationGroupUpdate build() {
            return new ReplicationGroupUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
