/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBackupResponse extends DynamoDbResponse implements
        ToCopyableBuilder<DescribeBackupResponse.Builder, DescribeBackupResponse> {
    private static final SdkField<BackupDescription> BACKUP_DESCRIPTION_FIELD = SdkField
            .<BackupDescription> builder(MarshallingType.SDK_POJO).memberName("BackupDescription")
            .getter(getter(DescribeBackupResponse::backupDescription)).setter(setter(Builder::backupDescription))
            .constructor(BackupDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupDescription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_DESCRIPTION_FIELD));

    private final BackupDescription backupDescription;

    private DescribeBackupResponse(BuilderImpl builder) {
        super(builder);
        this.backupDescription = builder.backupDescription;
    }

    /**
     * <p>
     * Contains the description of the backup created for the table.
     * </p>
     * 
     * @return Contains the description of the backup created for the table.
     */
    public final BackupDescription backupDescription() {
        return backupDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBackupResponse)) {
            return false;
        }
        DescribeBackupResponse other = (DescribeBackupResponse) obj;
        return Objects.equals(backupDescription(), other.backupDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeBackupResponse").add("BackupDescription", backupDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupDescription":
            return Optional.ofNullable(clazz.cast(backupDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBackupResponse, T> g) {
        return obj -> g.apply((DescribeBackupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeBackupResponse> {
        /**
         * <p>
         * Contains the description of the backup created for the table.
         * </p>
         * 
         * @param backupDescription
         *        Contains the description of the backup created for the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupDescription(BackupDescription backupDescription);

        /**
         * <p>
         * Contains the description of the backup created for the table.
         * </p>
         * This is a convenience method that creates an instance of the {@link BackupDescription.Builder} avoiding the
         * need to create one manually via {@link BackupDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link BackupDescription.Builder#build()} is called immediately and its
         * result is passed to {@link #backupDescription(BackupDescription)}.
         * 
         * @param backupDescription
         *        a consumer that will call methods on {@link BackupDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backupDescription(BackupDescription)
         */
        default Builder backupDescription(Consumer<BackupDescription.Builder> backupDescription) {
            return backupDescription(BackupDescription.builder().applyMutation(backupDescription).build());
        }
    }

    static final class BuilderImpl extends DynamoDbResponse.BuilderImpl implements Builder {
        private BackupDescription backupDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBackupResponse model) {
            super(model);
            backupDescription(model.backupDescription);
        }

        public final BackupDescription.Builder getBackupDescription() {
            return backupDescription != null ? backupDescription.toBuilder() : null;
        }

        public final void setBackupDescription(BackupDescription.BuilderImpl backupDescription) {
            this.backupDescription = backupDescription != null ? backupDescription.build() : null;
        }

        @Override
        public final Builder backupDescription(BackupDescription backupDescription) {
            this.backupDescription = backupDescription;
            return this;
        }

        @Override
        public DescribeBackupResponse build() {
            return new DescribeBackupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
