/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.ReplicaAutoScalingDescription;
import software.amazon.awssdk.services.dynamodb.model.ReplicaAutoScalingDescriptionListCopier;
import software.amazon.awssdk.services.dynamodb.model.TableStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableAutoScalingDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableAutoScalingDescription> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(TableAutoScalingDescription.getter(TableAutoScalingDescription::tableName)).setter(TableAutoScalingDescription.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<String> TABLE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableStatus").getter(TableAutoScalingDescription.getter(TableAutoScalingDescription::tableStatusAsString)).setter(TableAutoScalingDescription.setter(Builder::tableStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableStatus").build()}).build();
    private static final SdkField<List<ReplicaAutoScalingDescription>> REPLICAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Replicas").getter(TableAutoScalingDescription.getter(TableAutoScalingDescription::replicas)).setter(TableAutoScalingDescription.setter(Builder::replicas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Replicas").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicaAutoScalingDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD, TABLE_STATUS_FIELD, REPLICAS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String tableName;
    private final String tableStatus;
    private final List<ReplicaAutoScalingDescription> replicas;

    private TableAutoScalingDescription(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.tableStatus = builder.tableStatus;
        this.replicas = builder.replicas;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final TableStatus tableStatus() {
        return TableStatus.fromValue(this.tableStatus);
    }

    public final String tableStatusAsString() {
        return this.tableStatus;
    }

    public final boolean hasReplicas() {
        return this.replicas != null && !(this.replicas instanceof SdkAutoConstructList);
    }

    public final List<ReplicaAutoScalingDescription> replicas() {
        return this.replicas;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicas() ? this.replicas() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableAutoScalingDescription)) {
            return false;
        }
        TableAutoScalingDescription other = (TableAutoScalingDescription)obj;
        return Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.tableStatusAsString(), other.tableStatusAsString()) && this.hasReplicas() == other.hasReplicas() && Objects.equals(this.replicas(), other.replicas());
    }

    public final String toString() {
        return ToString.builder((String)"TableAutoScalingDescription").add("TableName", (Object)this.tableName()).add("TableStatus", (Object)this.tableStatusAsString()).add("Replicas", this.hasReplicas() ? this.replicas() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "TableStatus": {
                return Optional.ofNullable(clazz.cast(this.tableStatusAsString()));
            }
            case "Replicas": {
                return Optional.ofNullable(clazz.cast(this.replicas()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableAutoScalingDescription, T> g) {
        return obj -> g.apply((TableAutoScalingDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tableName;
        private String tableStatus;
        private List<ReplicaAutoScalingDescription> replicas = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TableAutoScalingDescription model) {
            this.tableName(model.tableName);
            this.tableStatus(model.tableStatus);
            this.replicas(model.replicas);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getTableStatus() {
            return this.tableStatus;
        }

        @Override
        public final Builder tableStatus(String tableStatus) {
            this.tableStatus = tableStatus;
            return this;
        }

        @Override
        public final Builder tableStatus(TableStatus tableStatus) {
            this.tableStatus(tableStatus == null ? null : tableStatus.toString());
            return this;
        }

        public final void setTableStatus(String tableStatus) {
            this.tableStatus = tableStatus;
        }

        public final List<ReplicaAutoScalingDescription.Builder> getReplicas() {
            List<ReplicaAutoScalingDescription.Builder> result = ReplicaAutoScalingDescriptionListCopier.copyToBuilder(this.replicas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder replicas(Collection<ReplicaAutoScalingDescription> replicas) {
            this.replicas = ReplicaAutoScalingDescriptionListCopier.copy(replicas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicas(ReplicaAutoScalingDescription ... replicas) {
            this.replicas(Arrays.asList(replicas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicas(Consumer<ReplicaAutoScalingDescription.Builder> ... replicas) {
            this.replicas(Stream.of(replicas).map(c -> (ReplicaAutoScalingDescription)((ReplicaAutoScalingDescription.Builder)ReplicaAutoScalingDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReplicas(Collection<ReplicaAutoScalingDescription.BuilderImpl> replicas) {
            this.replicas = ReplicaAutoScalingDescriptionListCopier.copyFromBuilder(replicas);
        }

        public TableAutoScalingDescription build() {
            return new TableAutoScalingDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableAutoScalingDescription> {
        public Builder tableName(String var1);

        public Builder tableStatus(String var1);

        public Builder tableStatus(TableStatus var1);

        public Builder replicas(Collection<ReplicaAutoScalingDescription> var1);

        public Builder replicas(ReplicaAutoScalingDescription ... var1);

        public Builder replicas(Consumer<ReplicaAutoScalingDescription.Builder> ... var1);
    }
}

