/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ExpressionAttributeNameMapCopier;
import software.amazon.awssdk.services.dynamodb.model.ExpressionAttributeValueMapCopier;
import software.amazon.awssdk.services.dynamodb.model.KeyCopier;
import software.amazon.awssdk.services.dynamodb.model.ReturnValuesOnConditionCheckFailure;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConditionCheck
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConditionCheck> {
    private static final SdkField<Map<String, AttributeValue>> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Key").getter(ConditionCheck.getter(ConditionCheck::key)).setter(ConditionCheck.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(ConditionCheck.getter(ConditionCheck::tableName)).setter(ConditionCheck.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<String> CONDITION_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConditionExpression").getter(ConditionCheck.getter(ConditionCheck::conditionExpression)).setter(ConditionCheck.setter(Builder::conditionExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionExpression").build()}).build();
    private static final SdkField<Map<String, String>> EXPRESSION_ATTRIBUTE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ExpressionAttributeNames").getter(ConditionCheck.getter(ConditionCheck::expressionAttributeNames)).setter(ConditionCheck.setter(Builder::expressionAttributeNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionAttributeNames").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, AttributeValue>> EXPRESSION_ATTRIBUTE_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ExpressionAttributeValues").getter(ConditionCheck.getter(ConditionCheck::expressionAttributeValues)).setter(ConditionCheck.setter(Builder::expressionAttributeValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionAttributeValues").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RETURN_VALUES_ON_CONDITION_CHECK_FAILURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReturnValuesOnConditionCheckFailure").getter(ConditionCheck.getter(ConditionCheck::returnValuesOnConditionCheckFailureAsString)).setter(ConditionCheck.setter(Builder::returnValuesOnConditionCheckFailure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnValuesOnConditionCheckFailure").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, TABLE_NAME_FIELD, CONDITION_EXPRESSION_FIELD, EXPRESSION_ATTRIBUTE_NAMES_FIELD, EXPRESSION_ATTRIBUTE_VALUES_FIELD, RETURN_VALUES_ON_CONDITION_CHECK_FAILURE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, AttributeValue> key;
    private final String tableName;
    private final String conditionExpression;
    private final Map<String, String> expressionAttributeNames;
    private final Map<String, AttributeValue> expressionAttributeValues;
    private final String returnValuesOnConditionCheckFailure;

    private ConditionCheck(BuilderImpl builder) {
        this.key = builder.key;
        this.tableName = builder.tableName;
        this.conditionExpression = builder.conditionExpression;
        this.expressionAttributeNames = builder.expressionAttributeNames;
        this.expressionAttributeValues = builder.expressionAttributeValues;
        this.returnValuesOnConditionCheckFailure = builder.returnValuesOnConditionCheckFailure;
    }

    public final boolean hasKey() {
        return this.key != null && !(this.key instanceof SdkAutoConstructMap);
    }

    public final Map<String, AttributeValue> key() {
        return this.key;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final String conditionExpression() {
        return this.conditionExpression;
    }

    public final boolean hasExpressionAttributeNames() {
        return this.expressionAttributeNames != null && !(this.expressionAttributeNames instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> expressionAttributeNames() {
        return this.expressionAttributeNames;
    }

    public final boolean hasExpressionAttributeValues() {
        return this.expressionAttributeValues != null && !(this.expressionAttributeValues instanceof SdkAutoConstructMap);
    }

    public final Map<String, AttributeValue> expressionAttributeValues() {
        return this.expressionAttributeValues;
    }

    public final ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure() {
        return ReturnValuesOnConditionCheckFailure.fromValue(this.returnValuesOnConditionCheckFailure);
    }

    public final String returnValuesOnConditionCheckFailureAsString() {
        return this.returnValuesOnConditionCheckFailure;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKey() ? this.key() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExpressionAttributeNames() ? this.expressionAttributeNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExpressionAttributeValues() ? this.expressionAttributeValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.returnValuesOnConditionCheckFailureAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionCheck)) {
            return false;
        }
        ConditionCheck other = (ConditionCheck)obj;
        return this.hasKey() == other.hasKey() && Objects.equals(this.key(), other.key()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.conditionExpression(), other.conditionExpression()) && this.hasExpressionAttributeNames() == other.hasExpressionAttributeNames() && Objects.equals(this.expressionAttributeNames(), other.expressionAttributeNames()) && this.hasExpressionAttributeValues() == other.hasExpressionAttributeValues() && Objects.equals(this.expressionAttributeValues(), other.expressionAttributeValues()) && Objects.equals(this.returnValuesOnConditionCheckFailureAsString(), other.returnValuesOnConditionCheckFailureAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ConditionCheck").add("Key", this.hasKey() ? this.key() : null).add("TableName", (Object)this.tableName()).add("ConditionExpression", (Object)this.conditionExpression()).add("ExpressionAttributeNames", this.hasExpressionAttributeNames() ? this.expressionAttributeNames() : null).add("ExpressionAttributeValues", this.hasExpressionAttributeValues() ? this.expressionAttributeValues() : null).add("ReturnValuesOnConditionCheckFailure", (Object)this.returnValuesOnConditionCheckFailureAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "ConditionExpression": {
                return Optional.ofNullable(clazz.cast(this.conditionExpression()));
            }
            case "ExpressionAttributeNames": {
                return Optional.ofNullable(clazz.cast(this.expressionAttributeNames()));
            }
            case "ExpressionAttributeValues": {
                return Optional.ofNullable(clazz.cast(this.expressionAttributeValues()));
            }
            case "ReturnValuesOnConditionCheckFailure": {
                return Optional.ofNullable(clazz.cast(this.returnValuesOnConditionCheckFailureAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConditionCheck, T> g) {
        return obj -> g.apply((ConditionCheck)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, AttributeValue> key = DefaultSdkAutoConstructMap.getInstance();
        private String tableName;
        private String conditionExpression;
        private Map<String, String> expressionAttributeNames = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, AttributeValue> expressionAttributeValues = DefaultSdkAutoConstructMap.getInstance();
        private String returnValuesOnConditionCheckFailure;

        private BuilderImpl() {
        }

        private BuilderImpl(ConditionCheck model) {
            this.key(model.key);
            this.tableName(model.tableName);
            this.conditionExpression(model.conditionExpression);
            this.expressionAttributeNames(model.expressionAttributeNames);
            this.expressionAttributeValues(model.expressionAttributeValues);
            this.returnValuesOnConditionCheckFailure(model.returnValuesOnConditionCheckFailure);
        }

        public final Map<String, AttributeValue.Builder> getKey() {
            Map<String, AttributeValue.Builder> result = KeyCopier.copyToBuilder(this.key);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder key(Map<String, AttributeValue> key) {
            this.key = KeyCopier.copy(key);
            return this;
        }

        public final void setKey(Map<String, AttributeValue.BuilderImpl> key) {
            this.key = KeyCopier.copyFromBuilder(key);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getConditionExpression() {
            return this.conditionExpression;
        }

        @Override
        public final Builder conditionExpression(String conditionExpression) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        public final void setConditionExpression(String conditionExpression) {
            this.conditionExpression = conditionExpression;
        }

        public final Map<String, String> getExpressionAttributeNames() {
            if (this.expressionAttributeNames instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.expressionAttributeNames;
        }

        @Override
        public final Builder expressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
            return this;
        }

        public final void setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
        }

        public final Map<String, AttributeValue.Builder> getExpressionAttributeValues() {
            Map<String, AttributeValue.Builder> result = ExpressionAttributeValueMapCopier.copyToBuilder(this.expressionAttributeValues);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder expressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copy(expressionAttributeValues);
            return this;
        }

        public final void setExpressionAttributeValues(Map<String, AttributeValue.BuilderImpl> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copyFromBuilder(expressionAttributeValues);
        }

        public final String getReturnValuesOnConditionCheckFailure() {
            return this.returnValuesOnConditionCheckFailure;
        }

        @Override
        public final Builder returnValuesOnConditionCheckFailure(String returnValuesOnConditionCheckFailure) {
            this.returnValuesOnConditionCheckFailure = returnValuesOnConditionCheckFailure;
            return this;
        }

        @Override
        public final Builder returnValuesOnConditionCheckFailure(ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure) {
            this.returnValuesOnConditionCheckFailure(returnValuesOnConditionCheckFailure == null ? null : returnValuesOnConditionCheckFailure.toString());
            return this;
        }

        public final void setReturnValuesOnConditionCheckFailure(String returnValuesOnConditionCheckFailure) {
            this.returnValuesOnConditionCheckFailure = returnValuesOnConditionCheckFailure;
        }

        public ConditionCheck build() {
            return new ConditionCheck(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConditionCheck> {
        public Builder key(Map<String, AttributeValue> var1);

        public Builder tableName(String var1);

        public Builder conditionExpression(String var1);

        public Builder expressionAttributeNames(Map<String, String> var1);

        public Builder expressionAttributeValues(Map<String, AttributeValue> var1);

        public Builder returnValuesOnConditionCheckFailure(String var1);

        public Builder returnValuesOnConditionCheckFailure(ReturnValuesOnConditionCheckFailure var1);
    }
}

