/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ExportFormat {
    DYNAMODB_JSON("DYNAMODB_JSON"),
    ION("ION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ExportFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExportFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ExportFormat.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExportFormat> knownValues() {
        return Stream.of(ExportFormat.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

