/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGlobalTableSettingsRequest extends DynamoDbRequest implements
        ToCopyableBuilder<UpdateGlobalTableSettingsRequest.Builder, UpdateGlobalTableSettingsRequest> {
    private static final SdkField<String> GLOBAL_TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateGlobalTableSettingsRequest::globalTableName)).setter(setter(Builder::globalTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalTableName").build()).build();

    private static final SdkField<String> GLOBAL_TABLE_BILLING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateGlobalTableSettingsRequest::globalTableBillingModeAsString))
            .setter(setter(Builder::globalTableBillingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalTableBillingMode").build())
            .build();

    private static final SdkField<Long> GLOBAL_TABLE_PROVISIONED_WRITE_CAPACITY_UNITS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(UpdateGlobalTableSettingsRequest::globalTableProvisionedWriteCapacityUnits))
            .setter(setter(Builder::globalTableProvisionedWriteCapacityUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("GlobalTableProvisionedWriteCapacityUnits").build()).build();

    private static final SdkField<AutoScalingSettingsUpdate> GLOBAL_TABLE_PROVISIONED_WRITE_CAPACITY_AUTO_SCALING_SETTINGS_UPDATE_FIELD = SdkField
            .<AutoScalingSettingsUpdate> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateGlobalTableSettingsRequest::globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate))
            .setter(setter(Builder::globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate))
            .constructor(AutoScalingSettingsUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("GlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdate").build()).build();

    private static final SdkField<List<GlobalTableGlobalSecondaryIndexSettingsUpdate>> GLOBAL_TABLE_GLOBAL_SECONDARY_INDEX_SETTINGS_UPDATE_FIELD = SdkField
            .<List<GlobalTableGlobalSecondaryIndexSettingsUpdate>> builder(MarshallingType.LIST)
            .getter(getter(UpdateGlobalTableSettingsRequest::globalTableGlobalSecondaryIndexSettingsUpdate))
            .setter(setter(Builder::globalTableGlobalSecondaryIndexSettingsUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("GlobalTableGlobalSecondaryIndexSettingsUpdate").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GlobalTableGlobalSecondaryIndexSettingsUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(GlobalTableGlobalSecondaryIndexSettingsUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ReplicaSettingsUpdate>> REPLICA_SETTINGS_UPDATE_FIELD = SdkField
            .<List<ReplicaSettingsUpdate>> builder(MarshallingType.LIST)
            .getter(getter(UpdateGlobalTableSettingsRequest::replicaSettingsUpdate))
            .setter(setter(Builder::replicaSettingsUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaSettingsUpdate").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicaSettingsUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicaSettingsUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_TABLE_NAME_FIELD,
            GLOBAL_TABLE_BILLING_MODE_FIELD, GLOBAL_TABLE_PROVISIONED_WRITE_CAPACITY_UNITS_FIELD,
            GLOBAL_TABLE_PROVISIONED_WRITE_CAPACITY_AUTO_SCALING_SETTINGS_UPDATE_FIELD,
            GLOBAL_TABLE_GLOBAL_SECONDARY_INDEX_SETTINGS_UPDATE_FIELD, REPLICA_SETTINGS_UPDATE_FIELD));

    private final String globalTableName;

    private final String globalTableBillingMode;

    private final Long globalTableProvisionedWriteCapacityUnits;

    private final AutoScalingSettingsUpdate globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate;

    private final List<GlobalTableGlobalSecondaryIndexSettingsUpdate> globalTableGlobalSecondaryIndexSettingsUpdate;

    private final List<ReplicaSettingsUpdate> replicaSettingsUpdate;

    private UpdateGlobalTableSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.globalTableName = builder.globalTableName;
        this.globalTableBillingMode = builder.globalTableBillingMode;
        this.globalTableProvisionedWriteCapacityUnits = builder.globalTableProvisionedWriteCapacityUnits;
        this.globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate = builder.globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate;
        this.globalTableGlobalSecondaryIndexSettingsUpdate = builder.globalTableGlobalSecondaryIndexSettingsUpdate;
        this.replicaSettingsUpdate = builder.replicaSettingsUpdate;
    }

    /**
     * <p>
     * The name of the global table
     * </p>
     * 
     * @return The name of the global table
     */
    public String globalTableName() {
        return globalTableName;
    }

    /**
     * <p>
     * The billing mode of the global table. If <code>GlobalTableBillingMode</code> is not specified, the global table
     * defaults to <code>PROVISIONED</code> capacity billing mode.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads.
     * <code>PROVISIONED</code> sets the billing mode to <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual"
     * >Provisioned Mode</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads.
     * <code>PAY_PER_REQUEST</code> sets the billing mode to <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand"
     * >On-Demand Mode</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #globalTableBillingMode} will return {@link BillingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #globalTableBillingModeAsString}.
     * </p>
     * 
     * @return The billing mode of the global table. If <code>GlobalTableBillingMode</code> is not specified, the global
     *         table defaults to <code>PROVISIONED</code> capacity billing mode.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads.
     *         <code>PROVISIONED</code> sets the billing mode to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual"
     *         >Provisioned Mode</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable
     *         workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand"
     *         >On-Demand Mode</a>.
     *         </p>
     *         </li>
     * @see BillingMode
     */
    public BillingMode globalTableBillingMode() {
        return BillingMode.fromValue(globalTableBillingMode);
    }

    /**
     * <p>
     * The billing mode of the global table. If <code>GlobalTableBillingMode</code> is not specified, the global table
     * defaults to <code>PROVISIONED</code> capacity billing mode.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads.
     * <code>PROVISIONED</code> sets the billing mode to <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual"
     * >Provisioned Mode</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads.
     * <code>PAY_PER_REQUEST</code> sets the billing mode to <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand"
     * >On-Demand Mode</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #globalTableBillingMode} will return {@link BillingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #globalTableBillingModeAsString}.
     * </p>
     * 
     * @return The billing mode of the global table. If <code>GlobalTableBillingMode</code> is not specified, the global
     *         table defaults to <code>PROVISIONED</code> capacity billing mode.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads.
     *         <code>PROVISIONED</code> sets the billing mode to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual"
     *         >Provisioned Mode</a>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable
     *         workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand"
     *         >On-Demand Mode</a>.
     *         </p>
     *         </li>
     * @see BillingMode
     */
    public String globalTableBillingModeAsString() {
        return globalTableBillingMode;
    }

    /**
     * <p>
     * The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException.</code>
     * </p>
     * 
     * @return The maximum number of writes consumed per second before DynamoDB returns a
     *         <code>ThrottlingException.</code>
     */
    public Long globalTableProvisionedWriteCapacityUnits() {
        return globalTableProvisionedWriteCapacityUnits;
    }

    /**
     * <p>
     * Auto scaling settings for managing provisioned write capacity for the global table.
     * </p>
     * 
     * @return Auto scaling settings for managing provisioned write capacity for the global table.
     */
    public AutoScalingSettingsUpdate globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate() {
        return globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate;
    }

    /**
     * Returns true if the GlobalTableGlobalSecondaryIndexSettingsUpdate property was specified by the sender (it may be
     * empty), or false if the sender did not specify the value (it will be empty). For responses returned by the SDK,
     * the sender is the AWS service.
     */
    public boolean hasGlobalTableGlobalSecondaryIndexSettingsUpdate() {
        return globalTableGlobalSecondaryIndexSettingsUpdate != null
                && !(globalTableGlobalSecondaryIndexSettingsUpdate instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents the settings of a global secondary index for a global table that will be modified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGlobalTableGlobalSecondaryIndexSettingsUpdate()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Represents the settings of a global secondary index for a global table that will be modified.
     */
    public List<GlobalTableGlobalSecondaryIndexSettingsUpdate> globalTableGlobalSecondaryIndexSettingsUpdate() {
        return globalTableGlobalSecondaryIndexSettingsUpdate;
    }

    /**
     * Returns true if the ReplicaSettingsUpdate property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasReplicaSettingsUpdate() {
        return replicaSettingsUpdate != null && !(replicaSettingsUpdate instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents the settings for a global table in a Region that will be modified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReplicaSettingsUpdate()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Represents the settings for a global table in a Region that will be modified.
     */
    public List<ReplicaSettingsUpdate> replicaSettingsUpdate() {
        return replicaSettingsUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(globalTableName());
        hashCode = 31 * hashCode + Objects.hashCode(globalTableBillingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(globalTableProvisionedWriteCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(globalTableGlobalSecondaryIndexSettingsUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(replicaSettingsUpdate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGlobalTableSettingsRequest)) {
            return false;
        }
        UpdateGlobalTableSettingsRequest other = (UpdateGlobalTableSettingsRequest) obj;
        return Objects.equals(globalTableName(), other.globalTableName())
                && Objects.equals(globalTableBillingModeAsString(), other.globalTableBillingModeAsString())
                && Objects.equals(globalTableProvisionedWriteCapacityUnits(), other.globalTableProvisionedWriteCapacityUnits())
                && Objects.equals(globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate(),
                        other.globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate())
                && Objects.equals(globalTableGlobalSecondaryIndexSettingsUpdate(),
                        other.globalTableGlobalSecondaryIndexSettingsUpdate())
                && Objects.equals(replicaSettingsUpdate(), other.replicaSettingsUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString
                .builder("UpdateGlobalTableSettingsRequest")
                .add("GlobalTableName", globalTableName())
                .add("GlobalTableBillingMode", globalTableBillingModeAsString())
                .add("GlobalTableProvisionedWriteCapacityUnits", globalTableProvisionedWriteCapacityUnits())
                .add("GlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdate",
                        globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate())
                .add("GlobalTableGlobalSecondaryIndexSettingsUpdate", globalTableGlobalSecondaryIndexSettingsUpdate())
                .add("ReplicaSettingsUpdate", replicaSettingsUpdate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalTableName":
            return Optional.ofNullable(clazz.cast(globalTableName()));
        case "GlobalTableBillingMode":
            return Optional.ofNullable(clazz.cast(globalTableBillingModeAsString()));
        case "GlobalTableProvisionedWriteCapacityUnits":
            return Optional.ofNullable(clazz.cast(globalTableProvisionedWriteCapacityUnits()));
        case "GlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdate":
            return Optional.ofNullable(clazz.cast(globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate()));
        case "GlobalTableGlobalSecondaryIndexSettingsUpdate":
            return Optional.ofNullable(clazz.cast(globalTableGlobalSecondaryIndexSettingsUpdate()));
        case "ReplicaSettingsUpdate":
            return Optional.ofNullable(clazz.cast(replicaSettingsUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGlobalTableSettingsRequest, T> g) {
        return obj -> g.apply((UpdateGlobalTableSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateGlobalTableSettingsRequest> {
        /**
         * <p>
         * The name of the global table
         * </p>
         * 
         * @param globalTableName
         *        The name of the global table
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalTableName(String globalTableName);

        /**
         * <p>
         * The billing mode of the global table. If <code>GlobalTableBillingMode</code> is not specified, the global
         * table defaults to <code>PROVISIONED</code> capacity billing mode.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads.
         * <code>PROVISIONED</code> sets the billing mode to <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual"
         * >Provisioned Mode</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads.
         * <code>PAY_PER_REQUEST</code> sets the billing mode to <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand"
         * >On-Demand Mode</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param globalTableBillingMode
         *        The billing mode of the global table. If <code>GlobalTableBillingMode</code> is not specified, the
         *        global table defaults to <code>PROVISIONED</code> capacity billing mode.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads.
         *        <code>PROVISIONED</code> sets the billing mode to <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual"
         *        >Provisioned Mode</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable
         *        workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand"
         *        >On-Demand Mode</a>.
         *        </p>
         *        </li>
         * @see BillingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMode
         */
        Builder globalTableBillingMode(String globalTableBillingMode);

        /**
         * <p>
         * The billing mode of the global table. If <code>GlobalTableBillingMode</code> is not specified, the global
         * table defaults to <code>PROVISIONED</code> capacity billing mode.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads.
         * <code>PROVISIONED</code> sets the billing mode to <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual"
         * >Provisioned Mode</a>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable workloads.
         * <code>PAY_PER_REQUEST</code> sets the billing mode to <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand"
         * >On-Demand Mode</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param globalTableBillingMode
         *        The billing mode of the global table. If <code>GlobalTableBillingMode</code> is not specified, the
         *        global table defaults to <code>PROVISIONED</code> capacity billing mode.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PROVISIONED</code> - We recommend using <code>PROVISIONED</code> for predictable workloads.
         *        <code>PROVISIONED</code> sets the billing mode to <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual"
         *        >Provisioned Mode</a>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PAY_PER_REQUEST</code> - We recommend using <code>PAY_PER_REQUEST</code> for unpredictable
         *        workloads. <code>PAY_PER_REQUEST</code> sets the billing mode to <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand"
         *        >On-Demand Mode</a>.
         *        </p>
         *        </li>
         * @see BillingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillingMode
         */
        Builder globalTableBillingMode(BillingMode globalTableBillingMode);

        /**
         * <p>
         * The maximum number of writes consumed per second before DynamoDB returns a <code>ThrottlingException.</code>
         * </p>
         * 
         * @param globalTableProvisionedWriteCapacityUnits
         *        The maximum number of writes consumed per second before DynamoDB returns a
         *        <code>ThrottlingException.</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalTableProvisionedWriteCapacityUnits(Long globalTableProvisionedWriteCapacityUnits);

        /**
         * <p>
         * Auto scaling settings for managing provisioned write capacity for the global table.
         * </p>
         * 
         * @param globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate
         *        Auto scaling settings for managing provisioned write capacity for the global table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate(
                AutoScalingSettingsUpdate globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate);

        /**
         * <p>
         * Auto scaling settings for managing provisioned write capacity for the global table.
         * </p>
         * This is a convenience that creates an instance of the {@link AutoScalingSettingsUpdate.Builder} avoiding the
         * need to create one manually via {@link AutoScalingSettingsUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoScalingSettingsUpdate.Builder#build()} is called immediately
         * and its result is passed to
         * {@link #globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate(AutoScalingSettingsUpdate)}.
         * 
         * @param globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate
         *        a consumer that will call methods on {@link AutoScalingSettingsUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate(AutoScalingSettingsUpdate)
         */
        default Builder globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate(
                Consumer<AutoScalingSettingsUpdate.Builder> globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate) {
            return globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate(AutoScalingSettingsUpdate.builder()
                    .applyMutation(globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate).build());
        }

        /**
         * <p>
         * Represents the settings of a global secondary index for a global table that will be modified.
         * </p>
         * 
         * @param globalTableGlobalSecondaryIndexSettingsUpdate
         *        Represents the settings of a global secondary index for a global table that will be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalTableGlobalSecondaryIndexSettingsUpdate(
                Collection<GlobalTableGlobalSecondaryIndexSettingsUpdate> globalTableGlobalSecondaryIndexSettingsUpdate);

        /**
         * <p>
         * Represents the settings of a global secondary index for a global table that will be modified.
         * </p>
         * 
         * @param globalTableGlobalSecondaryIndexSettingsUpdate
         *        Represents the settings of a global secondary index for a global table that will be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalTableGlobalSecondaryIndexSettingsUpdate(
                GlobalTableGlobalSecondaryIndexSettingsUpdate... globalTableGlobalSecondaryIndexSettingsUpdate);

        /**
         * <p>
         * Represents the settings of a global secondary index for a global table that will be modified.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <GlobalTableGlobalSecondaryIndexSettingsUpdate>.Builder} avoiding the need to create one manually via
         * {@link List<GlobalTableGlobalSecondaryIndexSettingsUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <GlobalTableGlobalSecondaryIndexSettingsUpdate>.Builder#build()} is called immediately and its result is
         * passed to {@link
         * #globalTableGlobalSecondaryIndexSettingsUpdate(List<GlobalTableGlobalSecondaryIndexSettingsUpdate>)}.
         * 
         * @param globalTableGlobalSecondaryIndexSettingsUpdate
         *        a consumer that will call methods on {@link List
         *        <GlobalTableGlobalSecondaryIndexSettingsUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalTableGlobalSecondaryIndexSettingsUpdate(List<GlobalTableGlobalSecondaryIndexSettingsUpdate>)
         */
        Builder globalTableGlobalSecondaryIndexSettingsUpdate(
                Consumer<GlobalTableGlobalSecondaryIndexSettingsUpdate.Builder>... globalTableGlobalSecondaryIndexSettingsUpdate);

        /**
         * <p>
         * Represents the settings for a global table in a Region that will be modified.
         * </p>
         * 
         * @param replicaSettingsUpdate
         *        Represents the settings for a global table in a Region that will be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaSettingsUpdate(Collection<ReplicaSettingsUpdate> replicaSettingsUpdate);

        /**
         * <p>
         * Represents the settings for a global table in a Region that will be modified.
         * </p>
         * 
         * @param replicaSettingsUpdate
         *        Represents the settings for a global table in a Region that will be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaSettingsUpdate(ReplicaSettingsUpdate... replicaSettingsUpdate);

        /**
         * <p>
         * Represents the settings for a global table in a Region that will be modified.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReplicaSettingsUpdate>.Builder} avoiding
         * the need to create one manually via {@link List<ReplicaSettingsUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReplicaSettingsUpdate>.Builder#build()} is called
         * immediately and its result is passed to {@link #replicaSettingsUpdate(List<ReplicaSettingsUpdate>)}.
         * 
         * @param replicaSettingsUpdate
         *        a consumer that will call methods on {@link List<ReplicaSettingsUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicaSettingsUpdate(List<ReplicaSettingsUpdate>)
         */
        Builder replicaSettingsUpdate(Consumer<ReplicaSettingsUpdate.Builder>... replicaSettingsUpdate);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbRequest.BuilderImpl implements Builder {
        private String globalTableName;

        private String globalTableBillingMode;

        private Long globalTableProvisionedWriteCapacityUnits;

        private AutoScalingSettingsUpdate globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate;

        private List<GlobalTableGlobalSecondaryIndexSettingsUpdate> globalTableGlobalSecondaryIndexSettingsUpdate = DefaultSdkAutoConstructList
                .getInstance();

        private List<ReplicaSettingsUpdate> replicaSettingsUpdate = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGlobalTableSettingsRequest model) {
            super(model);
            globalTableName(model.globalTableName);
            globalTableBillingMode(model.globalTableBillingMode);
            globalTableProvisionedWriteCapacityUnits(model.globalTableProvisionedWriteCapacityUnits);
            globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate(model.globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate);
            globalTableGlobalSecondaryIndexSettingsUpdate(model.globalTableGlobalSecondaryIndexSettingsUpdate);
            replicaSettingsUpdate(model.replicaSettingsUpdate);
        }

        public final String getGlobalTableName() {
            return globalTableName;
        }

        @Override
        public final Builder globalTableName(String globalTableName) {
            this.globalTableName = globalTableName;
            return this;
        }

        public final void setGlobalTableName(String globalTableName) {
            this.globalTableName = globalTableName;
        }

        public final String getGlobalTableBillingMode() {
            return globalTableBillingMode;
        }

        @Override
        public final Builder globalTableBillingMode(String globalTableBillingMode) {
            this.globalTableBillingMode = globalTableBillingMode;
            return this;
        }

        @Override
        public final Builder globalTableBillingMode(BillingMode globalTableBillingMode) {
            this.globalTableBillingMode(globalTableBillingMode == null ? null : globalTableBillingMode.toString());
            return this;
        }

        public final void setGlobalTableBillingMode(String globalTableBillingMode) {
            this.globalTableBillingMode = globalTableBillingMode;
        }

        public final Long getGlobalTableProvisionedWriteCapacityUnits() {
            return globalTableProvisionedWriteCapacityUnits;
        }

        @Override
        public final Builder globalTableProvisionedWriteCapacityUnits(Long globalTableProvisionedWriteCapacityUnits) {
            this.globalTableProvisionedWriteCapacityUnits = globalTableProvisionedWriteCapacityUnits;
            return this;
        }

        public final void setGlobalTableProvisionedWriteCapacityUnits(Long globalTableProvisionedWriteCapacityUnits) {
            this.globalTableProvisionedWriteCapacityUnits = globalTableProvisionedWriteCapacityUnits;
        }

        public final AutoScalingSettingsUpdate.Builder getGlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdate() {
            return globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate != null ? globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate
                    .toBuilder() : null;
        }

        @Override
        public final Builder globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate(
                AutoScalingSettingsUpdate globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate) {
            this.globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate = globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate;
            return this;
        }

        public final void setGlobalTableProvisionedWriteCapacityAutoScalingSettingsUpdate(
                AutoScalingSettingsUpdate.BuilderImpl globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate) {
            this.globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate = globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate != null ? globalTableProvisionedWriteCapacityAutoScalingSettingsUpdate
                    .build() : null;
        }

        public final Collection<GlobalTableGlobalSecondaryIndexSettingsUpdate.Builder> getGlobalTableGlobalSecondaryIndexSettingsUpdate() {
            return globalTableGlobalSecondaryIndexSettingsUpdate != null ? globalTableGlobalSecondaryIndexSettingsUpdate.stream()
                    .map(GlobalTableGlobalSecondaryIndexSettingsUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder globalTableGlobalSecondaryIndexSettingsUpdate(
                Collection<GlobalTableGlobalSecondaryIndexSettingsUpdate> globalTableGlobalSecondaryIndexSettingsUpdate) {
            this.globalTableGlobalSecondaryIndexSettingsUpdate = GlobalTableGlobalSecondaryIndexSettingsUpdateListCopier
                    .copy(globalTableGlobalSecondaryIndexSettingsUpdate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalTableGlobalSecondaryIndexSettingsUpdate(
                GlobalTableGlobalSecondaryIndexSettingsUpdate... globalTableGlobalSecondaryIndexSettingsUpdate) {
            globalTableGlobalSecondaryIndexSettingsUpdate(Arrays.asList(globalTableGlobalSecondaryIndexSettingsUpdate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalTableGlobalSecondaryIndexSettingsUpdate(
                Consumer<GlobalTableGlobalSecondaryIndexSettingsUpdate.Builder>... globalTableGlobalSecondaryIndexSettingsUpdate) {
            globalTableGlobalSecondaryIndexSettingsUpdate(Stream.of(globalTableGlobalSecondaryIndexSettingsUpdate)
                    .map(c -> GlobalTableGlobalSecondaryIndexSettingsUpdate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setGlobalTableGlobalSecondaryIndexSettingsUpdate(
                Collection<GlobalTableGlobalSecondaryIndexSettingsUpdate.BuilderImpl> globalTableGlobalSecondaryIndexSettingsUpdate) {
            this.globalTableGlobalSecondaryIndexSettingsUpdate = GlobalTableGlobalSecondaryIndexSettingsUpdateListCopier
                    .copyFromBuilder(globalTableGlobalSecondaryIndexSettingsUpdate);
        }

        public final Collection<ReplicaSettingsUpdate.Builder> getReplicaSettingsUpdate() {
            return replicaSettingsUpdate != null ? replicaSettingsUpdate.stream().map(ReplicaSettingsUpdate::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replicaSettingsUpdate(Collection<ReplicaSettingsUpdate> replicaSettingsUpdate) {
            this.replicaSettingsUpdate = ReplicaSettingsUpdateListCopier.copy(replicaSettingsUpdate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaSettingsUpdate(ReplicaSettingsUpdate... replicaSettingsUpdate) {
            replicaSettingsUpdate(Arrays.asList(replicaSettingsUpdate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaSettingsUpdate(Consumer<ReplicaSettingsUpdate.Builder>... replicaSettingsUpdate) {
            replicaSettingsUpdate(Stream.of(replicaSettingsUpdate)
                    .map(c -> ReplicaSettingsUpdate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReplicaSettingsUpdate(Collection<ReplicaSettingsUpdate.BuilderImpl> replicaSettingsUpdate) {
            this.replicaSettingsUpdate = ReplicaSettingsUpdateListCopier.copyFromBuilder(replicaSettingsUpdate);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGlobalTableSettingsRequest build() {
            return new UpdateGlobalTableSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
