/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateContributorInsightsRequest extends DynamoDbRequest implements
        ToCopyableBuilder<UpdateContributorInsightsRequest.Builder, UpdateContributorInsightsRequest> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateContributorInsightsRequest::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateContributorInsightsRequest::indexName)).setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()).build();

    private static final SdkField<String> CONTRIBUTOR_INSIGHTS_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateContributorInsightsRequest::contributorInsightsActionAsString))
            .setter(setter(Builder::contributorInsightsAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContributorInsightsAction").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD,
            INDEX_NAME_FIELD, CONTRIBUTOR_INSIGHTS_ACTION_FIELD));

    private final String tableName;

    private final String indexName;

    private final String contributorInsightsAction;

    private UpdateContributorInsightsRequest(BuilderImpl builder) {
        super(builder);
        this.tableName = builder.tableName;
        this.indexName = builder.indexName;
        this.contributorInsightsAction = builder.contributorInsightsAction;
    }

    /**
     * <p>
     * The name of the table.
     * </p>
     * 
     * @return The name of the table.
     */
    public String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The global secondary index name, if applicable.
     * </p>
     * 
     * @return The global secondary index name, if applicable.
     */
    public String indexName() {
        return indexName;
    }

    /**
     * <p>
     * Represents the contributor insights action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contributorInsightsAction} will return {@link ContributorInsightsAction#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #contributorInsightsActionAsString}.
     * </p>
     * 
     * @return Represents the contributor insights action.
     * @see ContributorInsightsAction
     */
    public ContributorInsightsAction contributorInsightsAction() {
        return ContributorInsightsAction.fromValue(contributorInsightsAction);
    }

    /**
     * <p>
     * Represents the contributor insights action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contributorInsightsAction} will return {@link ContributorInsightsAction#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #contributorInsightsActionAsString}.
     * </p>
     * 
     * @return Represents the contributor insights action.
     * @see ContributorInsightsAction
     */
    public String contributorInsightsActionAsString() {
        return contributorInsightsAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(contributorInsightsActionAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContributorInsightsRequest)) {
            return false;
        }
        UpdateContributorInsightsRequest other = (UpdateContributorInsightsRequest) obj;
        return Objects.equals(tableName(), other.tableName()) && Objects.equals(indexName(), other.indexName())
                && Objects.equals(contributorInsightsActionAsString(), other.contributorInsightsActionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateContributorInsightsRequest").add("TableName", tableName()).add("IndexName", indexName())
                .add("ContributorInsightsAction", contributorInsightsActionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "IndexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "ContributorInsightsAction":
            return Optional.ofNullable(clazz.cast(contributorInsightsActionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateContributorInsightsRequest, T> g) {
        return obj -> g.apply((UpdateContributorInsightsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateContributorInsightsRequest> {
        /**
         * <p>
         * The name of the table.
         * </p>
         * 
         * @param tableName
         *        The name of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The global secondary index name, if applicable.
         * </p>
         * 
         * @param indexName
         *        The global secondary index name, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * Represents the contributor insights action.
         * </p>
         * 
         * @param contributorInsightsAction
         *        Represents the contributor insights action.
         * @see ContributorInsightsAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContributorInsightsAction
         */
        Builder contributorInsightsAction(String contributorInsightsAction);

        /**
         * <p>
         * Represents the contributor insights action.
         * </p>
         * 
         * @param contributorInsightsAction
         *        Represents the contributor insights action.
         * @see ContributorInsightsAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContributorInsightsAction
         */
        Builder contributorInsightsAction(ContributorInsightsAction contributorInsightsAction);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbRequest.BuilderImpl implements Builder {
        private String tableName;

        private String indexName;

        private String contributorInsightsAction;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContributorInsightsRequest model) {
            super(model);
            tableName(model.tableName);
            indexName(model.indexName);
            contributorInsightsAction(model.contributorInsightsAction);
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getIndexName() {
            return indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final String getContributorInsightsAction() {
            return contributorInsightsAction;
        }

        @Override
        public final Builder contributorInsightsAction(String contributorInsightsAction) {
            this.contributorInsightsAction = contributorInsightsAction;
            return this;
        }

        @Override
        public final Builder contributorInsightsAction(ContributorInsightsAction contributorInsightsAction) {
            this.contributorInsightsAction(contributorInsightsAction == null ? null : contributorInsightsAction.toString());
            return this;
        }

        public final void setContributorInsightsAction(String contributorInsightsAction) {
            this.contributorInsightsAction = contributorInsightsAction;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateContributorInsightsRequest build() {
            return new UpdateContributorInsightsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
