/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeContributorInsightsResponse extends DynamoDbResponse implements
        ToCopyableBuilder<DescribeContributorInsightsResponse.Builder, DescribeContributorInsightsResponse> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeContributorInsightsResponse::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeContributorInsightsResponse::indexName)).setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()).build();

    private static final SdkField<List<String>> CONTRIBUTOR_INSIGHTS_RULE_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeContributorInsightsResponse::contributorInsightsRuleList))
            .setter(setter(Builder::contributorInsightsRuleList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContributorInsightsRuleList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONTRIBUTOR_INSIGHTS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeContributorInsightsResponse::contributorInsightsStatusAsString))
            .setter(setter(Builder::contributorInsightsStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContributorInsightsStatus").build())
            .build();

    private static final SdkField<Instant> LAST_UPDATE_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeContributorInsightsResponse::lastUpdateDateTime)).setter(setter(Builder::lastUpdateDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateDateTime").build())
            .build();

    private static final SdkField<FailureException> FAILURE_EXCEPTION_FIELD = SdkField
            .<FailureException> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeContributorInsightsResponse::failureException)).setter(setter(Builder::failureException))
            .constructor(FailureException::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureException").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD,
            INDEX_NAME_FIELD, CONTRIBUTOR_INSIGHTS_RULE_LIST_FIELD, CONTRIBUTOR_INSIGHTS_STATUS_FIELD,
            LAST_UPDATE_DATE_TIME_FIELD, FAILURE_EXCEPTION_FIELD));

    private final String tableName;

    private final String indexName;

    private final List<String> contributorInsightsRuleList;

    private final String contributorInsightsStatus;

    private final Instant lastUpdateDateTime;

    private final FailureException failureException;

    private DescribeContributorInsightsResponse(BuilderImpl builder) {
        super(builder);
        this.tableName = builder.tableName;
        this.indexName = builder.indexName;
        this.contributorInsightsRuleList = builder.contributorInsightsRuleList;
        this.contributorInsightsStatus = builder.contributorInsightsStatus;
        this.lastUpdateDateTime = builder.lastUpdateDateTime;
        this.failureException = builder.failureException;
    }

    /**
     * <p>
     * The name of the table being described.
     * </p>
     * 
     * @return The name of the table being described.
     */
    public String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The name of the global secondary index being described.
     * </p>
     * 
     * @return The name of the global secondary index being described.
     */
    public String indexName() {
        return indexName;
    }

    /**
     * Returns true if the ContributorInsightsRuleList property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasContributorInsightsRuleList() {
        return contributorInsightsRuleList != null && !(contributorInsightsRuleList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of names of the associated Alpine rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasContributorInsightsRuleList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of names of the associated Alpine rules.
     */
    public List<String> contributorInsightsRuleList() {
        return contributorInsightsRuleList;
    }

    /**
     * <p>
     * Current Status contributor insights.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contributorInsightsStatus} will return {@link ContributorInsightsStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #contributorInsightsStatusAsString}.
     * </p>
     * 
     * @return Current Status contributor insights.
     * @see ContributorInsightsStatus
     */
    public ContributorInsightsStatus contributorInsightsStatus() {
        return ContributorInsightsStatus.fromValue(contributorInsightsStatus);
    }

    /**
     * <p>
     * Current Status contributor insights.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contributorInsightsStatus} will return {@link ContributorInsightsStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #contributorInsightsStatusAsString}.
     * </p>
     * 
     * @return Current Status contributor insights.
     * @see ContributorInsightsStatus
     */
    public String contributorInsightsStatusAsString() {
        return contributorInsightsStatus;
    }

    /**
     * <p>
     * Timestamp of the last time the status was changed.
     * </p>
     * 
     * @return Timestamp of the last time the status was changed.
     */
    public Instant lastUpdateDateTime() {
        return lastUpdateDateTime;
    }

    /**
     * <p>
     * Returns information about the last failure that encountered.
     * </p>
     * <p>
     * The most common exceptions for a FAILED status are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * LimitExceededException - Per-account Amazon CloudWatch Contributor Insights rule limit reached. Please disable
     * Contributor Insights for other tables/indexes OR disable Contributor Insights rules before retrying.
     * </p>
     * </li>
     * <li>
     * <p>
     * AccessDeniedException - Amazon CloudWatch Contributor Insights rules cannot be modified due to insufficient
     * permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * AccessDeniedException - Failed to create service-linked role for Contributor Insights due to insufficient
     * permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * InternalServerError - Failed to create Amazon CloudWatch Contributor Insights rules. Please retry request.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Returns information about the last failure that encountered.</p>
     *         <p>
     *         The most common exceptions for a FAILED status are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         LimitExceededException - Per-account Amazon CloudWatch Contributor Insights rule limit reached. Please
     *         disable Contributor Insights for other tables/indexes OR disable Contributor Insights rules before
     *         retrying.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AccessDeniedException - Amazon CloudWatch Contributor Insights rules cannot be modified due to
     *         insufficient permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AccessDeniedException - Failed to create service-linked role for Contributor Insights due to insufficient
     *         permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         InternalServerError - Failed to create Amazon CloudWatch Contributor Insights rules. Please retry
     *         request.
     *         </p>
     *         </li>
     */
    public FailureException failureException() {
        return failureException;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        hashCode = 31 * hashCode + Objects.hashCode(contributorInsightsRuleList());
        hashCode = 31 * hashCode + Objects.hashCode(contributorInsightsStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureException());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeContributorInsightsResponse)) {
            return false;
        }
        DescribeContributorInsightsResponse other = (DescribeContributorInsightsResponse) obj;
        return Objects.equals(tableName(), other.tableName()) && Objects.equals(indexName(), other.indexName())
                && Objects.equals(contributorInsightsRuleList(), other.contributorInsightsRuleList())
                && Objects.equals(contributorInsightsStatusAsString(), other.contributorInsightsStatusAsString())
                && Objects.equals(lastUpdateDateTime(), other.lastUpdateDateTime())
                && Objects.equals(failureException(), other.failureException());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeContributorInsightsResponse").add("TableName", tableName())
                .add("IndexName", indexName()).add("ContributorInsightsRuleList", contributorInsightsRuleList())
                .add("ContributorInsightsStatus", contributorInsightsStatusAsString())
                .add("LastUpdateDateTime", lastUpdateDateTime()).add("FailureException", failureException()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "IndexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        case "ContributorInsightsRuleList":
            return Optional.ofNullable(clazz.cast(contributorInsightsRuleList()));
        case "ContributorInsightsStatus":
            return Optional.ofNullable(clazz.cast(contributorInsightsStatusAsString()));
        case "LastUpdateDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateDateTime()));
        case "FailureException":
            return Optional.ofNullable(clazz.cast(failureException()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeContributorInsightsResponse, T> g) {
        return obj -> g.apply((DescribeContributorInsightsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeContributorInsightsResponse> {
        /**
         * <p>
         * The name of the table being described.
         * </p>
         * 
         * @param tableName
         *        The name of the table being described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The name of the global secondary index being described.
         * </p>
         * 
         * @param indexName
         *        The name of the global secondary index being described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);

        /**
         * <p>
         * List of names of the associated Alpine rules.
         * </p>
         * 
         * @param contributorInsightsRuleList
         *        List of names of the associated Alpine rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contributorInsightsRuleList(Collection<String> contributorInsightsRuleList);

        /**
         * <p>
         * List of names of the associated Alpine rules.
         * </p>
         * 
         * @param contributorInsightsRuleList
         *        List of names of the associated Alpine rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contributorInsightsRuleList(String... contributorInsightsRuleList);

        /**
         * <p>
         * Current Status contributor insights.
         * </p>
         * 
         * @param contributorInsightsStatus
         *        Current Status contributor insights.
         * @see ContributorInsightsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContributorInsightsStatus
         */
        Builder contributorInsightsStatus(String contributorInsightsStatus);

        /**
         * <p>
         * Current Status contributor insights.
         * </p>
         * 
         * @param contributorInsightsStatus
         *        Current Status contributor insights.
         * @see ContributorInsightsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContributorInsightsStatus
         */
        Builder contributorInsightsStatus(ContributorInsightsStatus contributorInsightsStatus);

        /**
         * <p>
         * Timestamp of the last time the status was changed.
         * </p>
         * 
         * @param lastUpdateDateTime
         *        Timestamp of the last time the status was changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateDateTime(Instant lastUpdateDateTime);

        /**
         * <p>
         * Returns information about the last failure that encountered.
         * </p>
         * <p>
         * The most common exceptions for a FAILED status are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * LimitExceededException - Per-account Amazon CloudWatch Contributor Insights rule limit reached. Please
         * disable Contributor Insights for other tables/indexes OR disable Contributor Insights rules before retrying.
         * </p>
         * </li>
         * <li>
         * <p>
         * AccessDeniedException - Amazon CloudWatch Contributor Insights rules cannot be modified due to insufficient
         * permissions.
         * </p>
         * </li>
         * <li>
         * <p>
         * AccessDeniedException - Failed to create service-linked role for Contributor Insights due to insufficient
         * permissions.
         * </p>
         * </li>
         * <li>
         * <p>
         * InternalServerError - Failed to create Amazon CloudWatch Contributor Insights rules. Please retry request.
         * </p>
         * </li>
         * </ul>
         * 
         * @param failureException
         *        Returns information about the last failure that encountered.</p>
         *        <p>
         *        The most common exceptions for a FAILED status are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        LimitExceededException - Per-account Amazon CloudWatch Contributor Insights rule limit reached. Please
         *        disable Contributor Insights for other tables/indexes OR disable Contributor Insights rules before
         *        retrying.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AccessDeniedException - Amazon CloudWatch Contributor Insights rules cannot be modified due to
         *        insufficient permissions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AccessDeniedException - Failed to create service-linked role for Contributor Insights due to
         *        insufficient permissions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        InternalServerError - Failed to create Amazon CloudWatch Contributor Insights rules. Please retry
         *        request.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureException(FailureException failureException);

        /**
         * <p>
         * Returns information about the last failure that encountered.
         * </p>
         * <p>
         * The most common exceptions for a FAILED status are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * LimitExceededException - Per-account Amazon CloudWatch Contributor Insights rule limit reached. Please
         * disable Contributor Insights for other tables/indexes OR disable Contributor Insights rules before retrying.
         * </p>
         * </li>
         * <li>
         * <p>
         * AccessDeniedException - Amazon CloudWatch Contributor Insights rules cannot be modified due to insufficient
         * permissions.
         * </p>
         * </li>
         * <li>
         * <p>
         * AccessDeniedException - Failed to create service-linked role for Contributor Insights due to insufficient
         * permissions.
         * </p>
         * </li>
         * <li>
         * <p>
         * InternalServerError - Failed to create Amazon CloudWatch Contributor Insights rules. Please retry request.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link FailureException.Builder} avoiding the need to
         * create one manually via {@link FailureException#builder()}.
         *
         * When the {@link Consumer} completes, {@link FailureException.Builder#build()} is called immediately and its
         * result is passed to {@link #failureException(FailureException)}.
         * 
         * @param failureException
         *        a consumer that will call methods on {@link FailureException.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failureException(FailureException)
         */
        default Builder failureException(Consumer<FailureException.Builder> failureException) {
            return failureException(FailureException.builder().applyMutation(failureException).build());
        }
    }

    static final class BuilderImpl extends DynamoDbResponse.BuilderImpl implements Builder {
        private String tableName;

        private String indexName;

        private List<String> contributorInsightsRuleList = DefaultSdkAutoConstructList.getInstance();

        private String contributorInsightsStatus;

        private Instant lastUpdateDateTime;

        private FailureException failureException;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeContributorInsightsResponse model) {
            super(model);
            tableName(model.tableName);
            indexName(model.indexName);
            contributorInsightsRuleList(model.contributorInsightsRuleList);
            contributorInsightsStatus(model.contributorInsightsStatus);
            lastUpdateDateTime(model.lastUpdateDateTime);
            failureException(model.failureException);
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getIndexName() {
            return indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final Collection<String> getContributorInsightsRuleList() {
            return contributorInsightsRuleList;
        }

        @Override
        public final Builder contributorInsightsRuleList(Collection<String> contributorInsightsRuleList) {
            this.contributorInsightsRuleList = ContributorInsightsRuleListCopier.copy(contributorInsightsRuleList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contributorInsightsRuleList(String... contributorInsightsRuleList) {
            contributorInsightsRuleList(Arrays.asList(contributorInsightsRuleList));
            return this;
        }

        public final void setContributorInsightsRuleList(Collection<String> contributorInsightsRuleList) {
            this.contributorInsightsRuleList = ContributorInsightsRuleListCopier.copy(contributorInsightsRuleList);
        }

        public final String getContributorInsightsStatusAsString() {
            return contributorInsightsStatus;
        }

        @Override
        public final Builder contributorInsightsStatus(String contributorInsightsStatus) {
            this.contributorInsightsStatus = contributorInsightsStatus;
            return this;
        }

        @Override
        public final Builder contributorInsightsStatus(ContributorInsightsStatus contributorInsightsStatus) {
            this.contributorInsightsStatus(contributorInsightsStatus == null ? null : contributorInsightsStatus.toString());
            return this;
        }

        public final void setContributorInsightsStatus(String contributorInsightsStatus) {
            this.contributorInsightsStatus = contributorInsightsStatus;
        }

        public final Instant getLastUpdateDateTime() {
            return lastUpdateDateTime;
        }

        @Override
        public final Builder lastUpdateDateTime(Instant lastUpdateDateTime) {
            this.lastUpdateDateTime = lastUpdateDateTime;
            return this;
        }

        public final void setLastUpdateDateTime(Instant lastUpdateDateTime) {
            this.lastUpdateDateTime = lastUpdateDateTime;
        }

        public final FailureException.Builder getFailureException() {
            return failureException != null ? failureException.toBuilder() : null;
        }

        @Override
        public final Builder failureException(FailureException failureException) {
            this.failureException = failureException;
            return this;
        }

        public final void setFailureException(FailureException.BuilderImpl failureException) {
            this.failureException = failureException != null ? failureException.build() : null;
        }

        @Override
        public DescribeContributorInsightsResponse build() {
            return new DescribeContributorInsightsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
