/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBackupsRequest extends DynamoDbRequest implements
        ToCopyableBuilder<ListBackupsRequest.Builder, ListBackupsRequest> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListBackupsRequest::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListBackupsRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<Instant> TIME_RANGE_LOWER_BOUND_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ListBackupsRequest::timeRangeLowerBound)).setter(setter(Builder::timeRangeLowerBound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeRangeLowerBound").build())
            .build();

    private static final SdkField<Instant> TIME_RANGE_UPPER_BOUND_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ListBackupsRequest::timeRangeUpperBound)).setter(setter(Builder::timeRangeUpperBound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeRangeUpperBound").build())
            .build();

    private static final SdkField<String> EXCLUSIVE_START_BACKUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListBackupsRequest::exclusiveStartBackupArn)).setter(setter(Builder::exclusiveStartBackupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveStartBackupArn").build())
            .build();

    private static final SdkField<String> BACKUP_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListBackupsRequest::backupTypeAsString)).setter(setter(Builder::backupType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD, LIMIT_FIELD,
            TIME_RANGE_LOWER_BOUND_FIELD, TIME_RANGE_UPPER_BOUND_FIELD, EXCLUSIVE_START_BACKUP_ARN_FIELD, BACKUP_TYPE_FIELD));

    private final String tableName;

    private final Integer limit;

    private final Instant timeRangeLowerBound;

    private final Instant timeRangeUpperBound;

    private final String exclusiveStartBackupArn;

    private final String backupType;

    private ListBackupsRequest(BuilderImpl builder) {
        super(builder);
        this.tableName = builder.tableName;
        this.limit = builder.limit;
        this.timeRangeLowerBound = builder.timeRangeLowerBound;
        this.timeRangeUpperBound = builder.timeRangeUpperBound;
        this.exclusiveStartBackupArn = builder.exclusiveStartBackupArn;
        this.backupType = builder.backupType;
    }

    /**
     * <p>
     * The backups from the table specified by <code>TableName</code> are listed.
     * </p>
     * 
     * @return The backups from the table specified by <code>TableName</code> are listed.
     */
    public String tableName() {
        return tableName;
    }

    /**
     * <p>
     * Maximum number of backups to return at once.
     * </p>
     * 
     * @return Maximum number of backups to return at once.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * Only backups created after this time are listed. <code>TimeRangeLowerBound</code> is inclusive.
     * </p>
     * 
     * @return Only backups created after this time are listed. <code>TimeRangeLowerBound</code> is inclusive.
     */
    public Instant timeRangeLowerBound() {
        return timeRangeLowerBound;
    }

    /**
     * <p>
     * Only backups created before this time are listed. <code>TimeRangeUpperBound</code> is exclusive.
     * </p>
     * 
     * @return Only backups created before this time are listed. <code>TimeRangeUpperBound</code> is exclusive.
     */
    public Instant timeRangeUpperBound() {
        return timeRangeUpperBound;
    }

    /**
     * <p>
     * <code>LastEvaluatedBackupArn</code> is the Amazon Resource Name (ARN) of the backup last evaluated when the
     * current page of results was returned, inclusive of the current page of results. This value may be specified as
     * the <code>ExclusiveStartBackupArn</code> of a new <code>ListBackups</code> operation in order to fetch the next
     * page of results.
     * </p>
     * 
     * @return <code>LastEvaluatedBackupArn</code> is the Amazon Resource Name (ARN) of the backup last evaluated when
     *         the current page of results was returned, inclusive of the current page of results. This value may be
     *         specified as the <code>ExclusiveStartBackupArn</code> of a new <code>ListBackups</code> operation in
     *         order to fetch the next page of results.
     */
    public String exclusiveStartBackupArn() {
        return exclusiveStartBackupArn;
    }

    /**
     * <p>
     * The backups from the table specified by <code>BackupType</code> are listed.
     * </p>
     * <p>
     * Where <code>BackupType</code> can be:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>USER</code> - On-demand backup created by you.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SYSTEM</code> - On-demand backup automatically created by DynamoDB.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL</code> - All types of on-demand backups (USER and SYSTEM).
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #backupType} will
     * return {@link BackupTypeFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #backupTypeAsString}.
     * </p>
     * 
     * @return The backups from the table specified by <code>BackupType</code> are listed.</p>
     *         <p>
     *         Where <code>BackupType</code> can be:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>USER</code> - On-demand backup created by you.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SYSTEM</code> - On-demand backup automatically created by DynamoDB.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL</code> - All types of on-demand backups (USER and SYSTEM).
     *         </p>
     *         </li>
     * @see BackupTypeFilter
     */
    public BackupTypeFilter backupType() {
        return BackupTypeFilter.fromValue(backupType);
    }

    /**
     * <p>
     * The backups from the table specified by <code>BackupType</code> are listed.
     * </p>
     * <p>
     * Where <code>BackupType</code> can be:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>USER</code> - On-demand backup created by you.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SYSTEM</code> - On-demand backup automatically created by DynamoDB.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL</code> - All types of on-demand backups (USER and SYSTEM).
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #backupType} will
     * return {@link BackupTypeFilter#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #backupTypeAsString}.
     * </p>
     * 
     * @return The backups from the table specified by <code>BackupType</code> are listed.</p>
     *         <p>
     *         Where <code>BackupType</code> can be:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>USER</code> - On-demand backup created by you.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SYSTEM</code> - On-demand backup automatically created by DynamoDB.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL</code> - All types of on-demand backups (USER and SYSTEM).
     *         </p>
     *         </li>
     * @see BackupTypeFilter
     */
    public String backupTypeAsString() {
        return backupType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(timeRangeLowerBound());
        hashCode = 31 * hashCode + Objects.hashCode(timeRangeUpperBound());
        hashCode = 31 * hashCode + Objects.hashCode(exclusiveStartBackupArn());
        hashCode = 31 * hashCode + Objects.hashCode(backupTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBackupsRequest)) {
            return false;
        }
        ListBackupsRequest other = (ListBackupsRequest) obj;
        return Objects.equals(tableName(), other.tableName()) && Objects.equals(limit(), other.limit())
                && Objects.equals(timeRangeLowerBound(), other.timeRangeLowerBound())
                && Objects.equals(timeRangeUpperBound(), other.timeRangeUpperBound())
                && Objects.equals(exclusiveStartBackupArn(), other.exclusiveStartBackupArn())
                && Objects.equals(backupTypeAsString(), other.backupTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListBackupsRequest").add("TableName", tableName()).add("Limit", limit())
                .add("TimeRangeLowerBound", timeRangeLowerBound()).add("TimeRangeUpperBound", timeRangeUpperBound())
                .add("ExclusiveStartBackupArn", exclusiveStartBackupArn()).add("BackupType", backupTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "TimeRangeLowerBound":
            return Optional.ofNullable(clazz.cast(timeRangeLowerBound()));
        case "TimeRangeUpperBound":
            return Optional.ofNullable(clazz.cast(timeRangeUpperBound()));
        case "ExclusiveStartBackupArn":
            return Optional.ofNullable(clazz.cast(exclusiveStartBackupArn()));
        case "BackupType":
            return Optional.ofNullable(clazz.cast(backupTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBackupsRequest, T> g) {
        return obj -> g.apply((ListBackupsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListBackupsRequest> {
        /**
         * <p>
         * The backups from the table specified by <code>TableName</code> are listed.
         * </p>
         * 
         * @param tableName
         *        The backups from the table specified by <code>TableName</code> are listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * Maximum number of backups to return at once.
         * </p>
         * 
         * @param limit
         *        Maximum number of backups to return at once.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * Only backups created after this time are listed. <code>TimeRangeLowerBound</code> is inclusive.
         * </p>
         * 
         * @param timeRangeLowerBound
         *        Only backups created after this time are listed. <code>TimeRangeLowerBound</code> is inclusive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeRangeLowerBound(Instant timeRangeLowerBound);

        /**
         * <p>
         * Only backups created before this time are listed. <code>TimeRangeUpperBound</code> is exclusive.
         * </p>
         * 
         * @param timeRangeUpperBound
         *        Only backups created before this time are listed. <code>TimeRangeUpperBound</code> is exclusive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeRangeUpperBound(Instant timeRangeUpperBound);

        /**
         * <p>
         * <code>LastEvaluatedBackupArn</code> is the Amazon Resource Name (ARN) of the backup last evaluated when the
         * current page of results was returned, inclusive of the current page of results. This value may be specified
         * as the <code>ExclusiveStartBackupArn</code> of a new <code>ListBackups</code> operation in order to fetch the
         * next page of results.
         * </p>
         * 
         * @param exclusiveStartBackupArn
         *        <code>LastEvaluatedBackupArn</code> is the Amazon Resource Name (ARN) of the backup last evaluated
         *        when the current page of results was returned, inclusive of the current page of results. This value
         *        may be specified as the <code>ExclusiveStartBackupArn</code> of a new <code>ListBackups</code>
         *        operation in order to fetch the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusiveStartBackupArn(String exclusiveStartBackupArn);

        /**
         * <p>
         * The backups from the table specified by <code>BackupType</code> are listed.
         * </p>
         * <p>
         * Where <code>BackupType</code> can be:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>USER</code> - On-demand backup created by you.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SYSTEM</code> - On-demand backup automatically created by DynamoDB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code> - All types of on-demand backups (USER and SYSTEM).
         * </p>
         * </li>
         * </ul>
         * 
         * @param backupType
         *        The backups from the table specified by <code>BackupType</code> are listed.</p>
         *        <p>
         *        Where <code>BackupType</code> can be:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>USER</code> - On-demand backup created by you.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SYSTEM</code> - On-demand backup automatically created by DynamoDB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code> - All types of on-demand backups (USER and SYSTEM).
         *        </p>
         *        </li>
         * @see BackupTypeFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BackupTypeFilter
         */
        Builder backupType(String backupType);

        /**
         * <p>
         * The backups from the table specified by <code>BackupType</code> are listed.
         * </p>
         * <p>
         * Where <code>BackupType</code> can be:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>USER</code> - On-demand backup created by you.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SYSTEM</code> - On-demand backup automatically created by DynamoDB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code> - All types of on-demand backups (USER and SYSTEM).
         * </p>
         * </li>
         * </ul>
         * 
         * @param backupType
         *        The backups from the table specified by <code>BackupType</code> are listed.</p>
         *        <p>
         *        Where <code>BackupType</code> can be:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>USER</code> - On-demand backup created by you.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SYSTEM</code> - On-demand backup automatically created by DynamoDB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code> - All types of on-demand backups (USER and SYSTEM).
         *        </p>
         *        </li>
         * @see BackupTypeFilter
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BackupTypeFilter
         */
        Builder backupType(BackupTypeFilter backupType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbRequest.BuilderImpl implements Builder {
        private String tableName;

        private Integer limit;

        private Instant timeRangeLowerBound;

        private Instant timeRangeUpperBound;

        private String exclusiveStartBackupArn;

        private String backupType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBackupsRequest model) {
            super(model);
            tableName(model.tableName);
            limit(model.limit);
            timeRangeLowerBound(model.timeRangeLowerBound);
            timeRangeUpperBound(model.timeRangeUpperBound);
            exclusiveStartBackupArn(model.exclusiveStartBackupArn);
            backupType(model.backupType);
        }

        public final String getTableName() {
            return tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final Instant getTimeRangeLowerBound() {
            return timeRangeLowerBound;
        }

        @Override
        public final Builder timeRangeLowerBound(Instant timeRangeLowerBound) {
            this.timeRangeLowerBound = timeRangeLowerBound;
            return this;
        }

        public final void setTimeRangeLowerBound(Instant timeRangeLowerBound) {
            this.timeRangeLowerBound = timeRangeLowerBound;
        }

        public final Instant getTimeRangeUpperBound() {
            return timeRangeUpperBound;
        }

        @Override
        public final Builder timeRangeUpperBound(Instant timeRangeUpperBound) {
            this.timeRangeUpperBound = timeRangeUpperBound;
            return this;
        }

        public final void setTimeRangeUpperBound(Instant timeRangeUpperBound) {
            this.timeRangeUpperBound = timeRangeUpperBound;
        }

        public final String getExclusiveStartBackupArn() {
            return exclusiveStartBackupArn;
        }

        @Override
        public final Builder exclusiveStartBackupArn(String exclusiveStartBackupArn) {
            this.exclusiveStartBackupArn = exclusiveStartBackupArn;
            return this;
        }

        public final void setExclusiveStartBackupArn(String exclusiveStartBackupArn) {
            this.exclusiveStartBackupArn = exclusiveStartBackupArn;
        }

        public final String getBackupTypeAsString() {
            return backupType;
        }

        @Override
        public final Builder backupType(String backupType) {
            this.backupType = backupType;
            return this;
        }

        @Override
        public final Builder backupType(BackupTypeFilter backupType) {
            this.backupType(backupType == null ? null : backupType.toString());
            return this;
        }

        public final void setBackupType(String backupType) {
            this.backupType = backupType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListBackupsRequest build() {
            return new ListBackupsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
