/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>GetItem</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetItemResponse extends DynamoDbResponse implements
        ToCopyableBuilder<GetItemResponse.Builder, GetItemResponse> {
    private static final SdkField<Map<String, AttributeValue>> ITEM_FIELD = SdkField
            .<Map<String, AttributeValue>> builder(MarshallingType.MAP)
            .getter(getter(GetItemResponse::item))
            .setter(setter(Builder::item))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ConsumedCapacity> CONSUMED_CAPACITY_FIELD = SdkField
            .<ConsumedCapacity> builder(MarshallingType.SDK_POJO).getter(getter(GetItemResponse::consumedCapacity))
            .setter(setter(Builder::consumedCapacity)).constructor(ConsumedCapacity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedCapacity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_FIELD,
            CONSUMED_CAPACITY_FIELD));

    private final Map<String, AttributeValue> item;

    private final ConsumedCapacity consumedCapacity;

    private GetItemResponse(BuilderImpl builder) {
        super(builder);
        this.item = builder.item;
        this.consumedCapacity = builder.consumedCapacity;
    }

    /**
     * <p>
     * A map of attribute names to <code>AttributeValue</code> objects, as specified by
     * <code>ProjectionExpression</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A map of attribute names to <code>AttributeValue</code> objects, as specified by
     *         <code>ProjectionExpression</code>.
     */
    public Map<String, AttributeValue> item() {
        return item;
    }

    /**
     * <p>
     * The capacity units consumed by the <code>GetItem</code> operation. The data returned includes the total
     * provisioned throughput consumed, along with statistics for the table and any indexes involved in the operation.
     * <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code> parameter was
     * specified. For more information, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html"
     * >Read/Write Capacity Mode</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return The capacity units consumed by the <code>GetItem</code> operation. The data returned includes the total
     *         provisioned throughput consumed, along with statistics for the table and any indexes involved in the
     *         operation. <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code>
     *         parameter was specified. For more information, see <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html"
     *         >Read/Write Capacity Mode</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public ConsumedCapacity consumedCapacity() {
        return consumedCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(item());
        hashCode = 31 * hashCode + Objects.hashCode(consumedCapacity());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetItemResponse)) {
            return false;
        }
        GetItemResponse other = (GetItemResponse) obj;
        return Objects.equals(item(), other.item()) && Objects.equals(consumedCapacity(), other.consumedCapacity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetItemResponse").add("Item", item()).add("ConsumedCapacity", consumedCapacity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Item":
            return Optional.ofNullable(clazz.cast(item()));
        case "ConsumedCapacity":
            return Optional.ofNullable(clazz.cast(consumedCapacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetItemResponse, T> g) {
        return obj -> g.apply((GetItemResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetItemResponse> {
        /**
         * <p>
         * A map of attribute names to <code>AttributeValue</code> objects, as specified by
         * <code>ProjectionExpression</code>.
         * </p>
         * 
         * @param item
         *        A map of attribute names to <code>AttributeValue</code> objects, as specified by
         *        <code>ProjectionExpression</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder item(Map<String, AttributeValue> item);

        /**
         * <p>
         * The capacity units consumed by the <code>GetItem</code> operation. The data returned includes the total
         * provisioned throughput consumed, along with statistics for the table and any indexes involved in the
         * operation. <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code>
         * parameter was specified. For more information, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html"
         * >Read/Write Capacity Mode</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param consumedCapacity
         *        The capacity units consumed by the <code>GetItem</code> operation. The data returned includes the
         *        total provisioned throughput consumed, along with statistics for the table and any indexes involved in
         *        the operation. <code>ConsumedCapacity</code> is only returned if the
         *        <code>ReturnConsumedCapacity</code> parameter was specified. For more information, see <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html"
         *        >Read/Write Capacity Mode</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumedCapacity(ConsumedCapacity consumedCapacity);

        /**
         * <p>
         * The capacity units consumed by the <code>GetItem</code> operation. The data returned includes the total
         * provisioned throughput consumed, along with statistics for the table and any indexes involved in the
         * operation. <code>ConsumedCapacity</code> is only returned if the <code>ReturnConsumedCapacity</code>
         * parameter was specified. For more information, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html"
         * >Read/Write Capacity Mode</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link ConsumedCapacity.Builder} avoiding the need to
         * create one manually via {@link ConsumedCapacity#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConsumedCapacity.Builder#build()} is called immediately and its
         * result is passed to {@link #consumedCapacity(ConsumedCapacity)}.
         * 
         * @param consumedCapacity
         *        a consumer that will call methods on {@link ConsumedCapacity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consumedCapacity(ConsumedCapacity)
         */
        default Builder consumedCapacity(Consumer<ConsumedCapacity.Builder> consumedCapacity) {
            return consumedCapacity(ConsumedCapacity.builder().applyMutation(consumedCapacity).build());
        }
    }

    static final class BuilderImpl extends DynamoDbResponse.BuilderImpl implements Builder {
        private Map<String, AttributeValue> item = DefaultSdkAutoConstructMap.getInstance();

        private ConsumedCapacity consumedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(GetItemResponse model) {
            super(model);
            item(model.item);
            consumedCapacity(model.consumedCapacity);
        }

        public final Map<String, AttributeValue.Builder> getItem() {
            return item != null ? CollectionUtils.mapValues(item, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder item(Map<String, AttributeValue> item) {
            this.item = AttributeMapCopier.copy(item);
            return this;
        }

        public final void setItem(Map<String, AttributeValue.BuilderImpl> item) {
            this.item = AttributeMapCopier.copyFromBuilder(item);
        }

        public final ConsumedCapacity.Builder getConsumedCapacity() {
            return consumedCapacity != null ? consumedCapacity.toBuilder() : null;
        }

        @Override
        public final Builder consumedCapacity(ConsumedCapacity consumedCapacity) {
            this.consumedCapacity = consumedCapacity;
            return this;
        }

        public final void setConsumedCapacity(ConsumedCapacity.BuilderImpl consumedCapacity) {
            this.consumedCapacity = consumedCapacity != null ? consumedCapacity.build() : null;
        }

        @Override
        public GetItemResponse build() {
            return new GetItemResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
