/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbRequest;
import software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoverySpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateContinuousBackupsRequest
extends DynamoDbRequest
implements ToCopyableBuilder<Builder, UpdateContinuousBackupsRequest> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateContinuousBackupsRequest.getter(UpdateContinuousBackupsRequest::tableName)).setter(UpdateContinuousBackupsRequest.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<PointInTimeRecoverySpecification> POINT_IN_TIME_RECOVERY_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateContinuousBackupsRequest.getter(UpdateContinuousBackupsRequest::pointInTimeRecoverySpecification)).setter(UpdateContinuousBackupsRequest.setter(Builder::pointInTimeRecoverySpecification)).constructor(PointInTimeRecoverySpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PointInTimeRecoverySpecification").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD, POINT_IN_TIME_RECOVERY_SPECIFICATION_FIELD));
    private final String tableName;
    private final PointInTimeRecoverySpecification pointInTimeRecoverySpecification;

    private UpdateContinuousBackupsRequest(BuilderImpl builder) {
        super(builder);
        this.tableName = builder.tableName;
        this.pointInTimeRecoverySpecification = builder.pointInTimeRecoverySpecification;
    }

    public String tableName() {
        return this.tableName;
    }

    public PointInTimeRecoverySpecification pointInTimeRecoverySpecification() {
        return this.pointInTimeRecoverySpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pointInTimeRecoverySpecification());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContinuousBackupsRequest)) {
            return false;
        }
        UpdateContinuousBackupsRequest other = (UpdateContinuousBackupsRequest)((Object)obj);
        return Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.pointInTimeRecoverySpecification(), other.pointInTimeRecoverySpecification());
    }

    public String toString() {
        return ToString.builder((String)"UpdateContinuousBackupsRequest").add("TableName", (Object)this.tableName()).add("PointInTimeRecoverySpecification", (Object)this.pointInTimeRecoverySpecification()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "PointInTimeRecoverySpecification": {
                return Optional.ofNullable(clazz.cast(this.pointInTimeRecoverySpecification()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateContinuousBackupsRequest, T> g) {
        return obj -> g.apply((UpdateContinuousBackupsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbRequest.BuilderImpl
    implements Builder {
        private String tableName;
        private PointInTimeRecoverySpecification pointInTimeRecoverySpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContinuousBackupsRequest model) {
            super(model);
            this.tableName(model.tableName);
            this.pointInTimeRecoverySpecification(model.pointInTimeRecoverySpecification);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final PointInTimeRecoverySpecification.Builder getPointInTimeRecoverySpecification() {
            return this.pointInTimeRecoverySpecification != null ? this.pointInTimeRecoverySpecification.toBuilder() : null;
        }

        @Override
        public final Builder pointInTimeRecoverySpecification(PointInTimeRecoverySpecification pointInTimeRecoverySpecification) {
            this.pointInTimeRecoverySpecification = pointInTimeRecoverySpecification;
            return this;
        }

        public final void setPointInTimeRecoverySpecification(PointInTimeRecoverySpecification.BuilderImpl pointInTimeRecoverySpecification) {
            this.pointInTimeRecoverySpecification = pointInTimeRecoverySpecification != null ? pointInTimeRecoverySpecification.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateContinuousBackupsRequest build() {
            return new UpdateContinuousBackupsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DynamoDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateContinuousBackupsRequest> {
        public Builder tableName(String var1);

        public Builder pointInTimeRecoverySpecification(PointInTimeRecoverySpecification var1);

        default public Builder pointInTimeRecoverySpecification(Consumer<PointInTimeRecoverySpecification.Builder> pointInTimeRecoverySpecification) {
            return this.pointInTimeRecoverySpecification((PointInTimeRecoverySpecification)((PointInTimeRecoverySpecification.Builder)PointInTimeRecoverySpecification.builder().applyMutation(pointInTimeRecoverySpecification)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

