/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.dynamodb.model.Capacity;
import software.amazon.awssdk.services.dynamodb.model.SecondaryIndexesCapacityMapCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConsumedCapacity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConsumedCapacity> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ConsumedCapacity.getter(ConsumedCapacity::tableName)).setter(ConsumedCapacity.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<Double> CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(ConsumedCapacity.getter(ConsumedCapacity::capacityUnits)).setter(ConsumedCapacity.setter(Builder::capacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityUnits").build()}).build();
    private static final SdkField<Capacity> TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ConsumedCapacity.getter(ConsumedCapacity::table)).setter(ConsumedCapacity.setter(Builder::table)).constructor(Capacity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()}).build();
    private static final SdkField<Map<String, Capacity>> LOCAL_SECONDARY_INDEXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(ConsumedCapacity.getter(ConsumedCapacity::localSecondaryIndexes)).setter(ConsumedCapacity.setter(Builder::localSecondaryIndexes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalSecondaryIndexes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Capacity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, Capacity>> GLOBAL_SECONDARY_INDEXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(ConsumedCapacity.getter(ConsumedCapacity::globalSecondaryIndexes)).setter(ConsumedCapacity.setter(Builder::globalSecondaryIndexes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSecondaryIndexes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Capacity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD, CAPACITY_UNITS_FIELD, TABLE_FIELD, LOCAL_SECONDARY_INDEXES_FIELD, GLOBAL_SECONDARY_INDEXES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String tableName;
    private final Double capacityUnits;
    private final Capacity table;
    private final Map<String, Capacity> localSecondaryIndexes;
    private final Map<String, Capacity> globalSecondaryIndexes;

    private ConsumedCapacity(BuilderImpl builder) {
        this.tableName = builder.tableName;
        this.capacityUnits = builder.capacityUnits;
        this.table = builder.table;
        this.localSecondaryIndexes = builder.localSecondaryIndexes;
        this.globalSecondaryIndexes = builder.globalSecondaryIndexes;
    }

    public String tableName() {
        return this.tableName;
    }

    public Double capacityUnits() {
        return this.capacityUnits;
    }

    public Capacity table() {
        return this.table;
    }

    public Map<String, Capacity> localSecondaryIndexes() {
        return this.localSecondaryIndexes;
    }

    public Map<String, Capacity> globalSecondaryIndexes() {
        return this.globalSecondaryIndexes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.table());
        hashCode = 31 * hashCode + Objects.hashCode(this.localSecondaryIndexes());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalSecondaryIndexes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConsumedCapacity)) {
            return false;
        }
        ConsumedCapacity other = (ConsumedCapacity)obj;
        return Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.capacityUnits(), other.capacityUnits()) && Objects.equals(this.table(), other.table()) && Objects.equals(this.localSecondaryIndexes(), other.localSecondaryIndexes()) && Objects.equals(this.globalSecondaryIndexes(), other.globalSecondaryIndexes());
    }

    public String toString() {
        return ToString.builder((String)"ConsumedCapacity").add("TableName", (Object)this.tableName()).add("CapacityUnits", (Object)this.capacityUnits()).add("Table", (Object)this.table()).add("LocalSecondaryIndexes", this.localSecondaryIndexes()).add("GlobalSecondaryIndexes", this.globalSecondaryIndexes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "CapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.capacityUnits()));
            }
            case "Table": {
                return Optional.ofNullable(clazz.cast(this.table()));
            }
            case "LocalSecondaryIndexes": {
                return Optional.ofNullable(clazz.cast(this.localSecondaryIndexes()));
            }
            case "GlobalSecondaryIndexes": {
                return Optional.ofNullable(clazz.cast(this.globalSecondaryIndexes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConsumedCapacity, T> g) {
        return obj -> g.apply((ConsumedCapacity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tableName;
        private Double capacityUnits;
        private Capacity table;
        private Map<String, Capacity> localSecondaryIndexes = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, Capacity> globalSecondaryIndexes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConsumedCapacity model) {
            this.tableName(model.tableName);
            this.capacityUnits(model.capacityUnits);
            this.table(model.table);
            this.localSecondaryIndexes(model.localSecondaryIndexes);
            this.globalSecondaryIndexes(model.globalSecondaryIndexes);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Double getCapacityUnits() {
            return this.capacityUnits;
        }

        @Override
        public final Builder capacityUnits(Double capacityUnits) {
            this.capacityUnits = capacityUnits;
            return this;
        }

        public final void setCapacityUnits(Double capacityUnits) {
            this.capacityUnits = capacityUnits;
        }

        public final Capacity.Builder getTable() {
            return this.table != null ? this.table.toBuilder() : null;
        }

        @Override
        public final Builder table(Capacity table) {
            this.table = table;
            return this;
        }

        public final void setTable(Capacity.BuilderImpl table) {
            this.table = table != null ? table.build() : null;
        }

        public final Map<String, Capacity.Builder> getLocalSecondaryIndexes() {
            return this.localSecondaryIndexes != null ? CollectionUtils.mapValues(this.localSecondaryIndexes, Capacity::toBuilder) : null;
        }

        @Override
        public final Builder localSecondaryIndexes(Map<String, Capacity> localSecondaryIndexes) {
            this.localSecondaryIndexes = SecondaryIndexesCapacityMapCopier.copy(localSecondaryIndexes);
            return this;
        }

        public final void setLocalSecondaryIndexes(Map<String, Capacity.BuilderImpl> localSecondaryIndexes) {
            this.localSecondaryIndexes = SecondaryIndexesCapacityMapCopier.copyFromBuilder(localSecondaryIndexes);
        }

        public final Map<String, Capacity.Builder> getGlobalSecondaryIndexes() {
            return this.globalSecondaryIndexes != null ? CollectionUtils.mapValues(this.globalSecondaryIndexes, Capacity::toBuilder) : null;
        }

        @Override
        public final Builder globalSecondaryIndexes(Map<String, Capacity> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = SecondaryIndexesCapacityMapCopier.copy(globalSecondaryIndexes);
            return this;
        }

        public final void setGlobalSecondaryIndexes(Map<String, Capacity.BuilderImpl> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = SecondaryIndexesCapacityMapCopier.copyFromBuilder(globalSecondaryIndexes);
        }

        public ConsumedCapacity build() {
            return new ConsumedCapacity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConsumedCapacity> {
        public Builder tableName(String var1);

        public Builder capacityUnits(Double var1);

        public Builder table(Capacity var1);

        default public Builder table(Consumer<Capacity.Builder> table) {
            return this.table((Capacity)((Capacity.Builder)Capacity.builder().applyMutation(table)).build());
        }

        public Builder localSecondaryIndexes(Map<String, Capacity> var1);

        public Builder globalSecondaryIndexes(Map<String, Capacity> var1);
    }
}

